/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteChunk;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePath;
import java.util.Objects;

public class RewriteChunkYaml
extends RewriteChunk {
    RewriteChunkYaml(RewritePath path, String chunk) {
        super(path, chunk);
    }

    @Override
    void extend(RewritePath differencePath) {
        while (differencePath.segmentCount() > 0) {
            String segmentWithoutSeparator = differencePath.removeLastSegment();
            this.indent(2);
            this.chunk = this.newLineSeparator + segmentWithoutSeparator + ":" + this.chunk;
            ++this.timesExtended;
            if (!Objects.equals(segmentWithoutSeparator, ConfigSections.HAZELCAST.getName())) continue;
            this.includesRootNode = true;
        }
    }

    @Override
    void indent(int spaceCount) {
        StringBuilder indent = new StringBuilder();
        indent.append(this.newLineSeparator);
        for (int i = 0; i < spaceCount; ++i) {
            indent.append(" ");
        }
        this.chunk = this.chunk.replace(this.newLineSeparator, indent.toString());
    }

    @Override
    int getSpaceCount() {
        return (this.path.segmentCount() - 1 - this.timesExtended) * 2;
    }
}

