/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigXmlGenerator;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.ExternalDataStoreConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.dynamicconfig.DynamicConfigXmlGenerator;
import com.hazelcast.internal.dynamicconfig.DynamicConfigYamlGenerator;
import com.hazelcast.internal.util.XmlUtil;
import com.hazelcast.org.snakeyaml.engine.v2.api.Dump;
import com.hazelcast.org.snakeyaml.engine.v2.api.DumpSettings;
import com.hazelcast.org.snakeyaml.engine.v2.common.FlowStyle;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class DynamicConfigGeneratorUtil {
    private DynamicConfigGeneratorUtil() {
    }

    public static String licenseKeyConfigGenerator(String subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, null, Config::setLicenseKey, DynamicConfigXmlGenerator::licenseKeyXmlGenerator, DynamicConfigYamlGenerator::licenseKeyYamlGenerator);
    }

    public static String wanReplicationConfigGenerator(WanReplicationConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.WAN_REPLICATION.getName(), Config::addWanReplicationConfig, DynamicConfigXmlGenerator::wanReplicationXmlGenerator, DynamicConfigYamlGenerator::wanReplicationYamlGenerator);
    }

    public static String mapConfigGenerator(MapConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.MAP.getName(), Config::addMapConfig, DynamicConfigXmlGenerator::mapXmlGenerator, DynamicConfigYamlGenerator::mapYamlGenerator);
    }

    public static String cacheConfigGenerator(CacheSimpleConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.CACHE.getName(), Config::addCacheConfig, DynamicConfigXmlGenerator::cacheXmlGenerator, DynamicConfigYamlGenerator::cacheYamlGenerator);
    }

    public static String queueConfigGenerator(QueueConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.QUEUE.getName(), Config::addQueueConfig, DynamicConfigXmlGenerator::queueXmlGenerator, DynamicConfigYamlGenerator::queueYamlGenerator);
    }

    public static String listConfigGenerator(ListConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.LIST.getName(), Config::addListConfig, DynamicConfigXmlGenerator::listXmlGenerator, DynamicConfigYamlGenerator::listYamlGenerator);
    }

    public static String setConfigGenerator(SetConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.SET.getName(), Config::addSetConfig, DynamicConfigXmlGenerator::setXmlGenerator, DynamicConfigYamlGenerator::setYamlGenerator);
    }

    public static String multiMapConfigGenerator(MultiMapConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.MULTIMAP.getName(), Config::addMultiMapConfig, DynamicConfigXmlGenerator::multiMapXmlGenerator, DynamicConfigYamlGenerator::multiMapYamlGenerator);
    }

    public static String replicatedMapConfigGenerator(ReplicatedMapConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.REPLICATED_MAP.getName(), Config::addReplicatedMapConfig, DynamicConfigXmlGenerator::replicatedMapXmlGenerator, DynamicConfigYamlGenerator::replicatedMapYamlGenerator);
    }

    public static String ringbufferConfigGenerator(RingbufferConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.RINGBUFFER.getName(), Config::addRingBufferConfig, DynamicConfigXmlGenerator::ringbufferXmlGenerator, DynamicConfigYamlGenerator::ringbufferYamlGenerator);
    }

    public static String topicConfigGenerator(TopicConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.TOPIC.getName(), Config::addTopicConfig, DynamicConfigXmlGenerator::topicXmlGenerator, DynamicConfigYamlGenerator::topicYamlGenerator);
    }

    public static String reliableTopicConfigGenerator(ReliableTopicConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.RELIABLE_TOPIC.getName(), Config::addReliableTopicConfig, DynamicConfigXmlGenerator::reliableTopicXmlGenerator, DynamicConfigYamlGenerator::reliableTopicYamlGenerator);
    }

    public static String executorConfigGenerator(ExecutorConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.EXECUTOR_SERVICE.getName(), Config::addExecutorConfig, DynamicConfigXmlGenerator::executorXmlGenerator, DynamicConfigYamlGenerator::executorYamlGenerator);
    }

    public static String durableExecutorConfigGenerator(DurableExecutorConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.DURABLE_EXECUTOR_SERVICE.getName(), Config::addDurableExecutorConfig, DynamicConfigXmlGenerator::durableExecutorXmlGenerator, DynamicConfigYamlGenerator::durableExecutorYamlGenerator);
    }

    public static String scheduledExecutorConfigGenerator(ScheduledExecutorConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.SCHEDULED_EXECUTOR_SERVICE.getName(), Config::addScheduledExecutorConfig, DynamicConfigXmlGenerator::scheduledExecutorXmlGenerator, DynamicConfigYamlGenerator::scheduledExecutorYamlGenerator);
    }

    public static String cardinalityEstimatorConfigGenerator(CardinalityEstimatorConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.CARDINALITY_ESTIMATOR.getName(), Config::addCardinalityEstimatorConfig, DynamicConfigXmlGenerator::cardinalityEstimatorXmlGenerator, DynamicConfigYamlGenerator::cardinalityEstimatorYamlGenerator);
    }

    public static String flakeIdGeneratorConfigGenerator(FlakeIdGeneratorConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.FLAKE_ID_GENERATOR.getName(), Config::addFlakeIdGeneratorConfig, DynamicConfigXmlGenerator::flakeIdGeneratorXmlGenerator, DynamicConfigYamlGenerator::flakeIdGeneratorYamlGenerator);
    }

    public static String pnCounterConfigGenerator(PNCounterConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.PN_COUNTER.getName(), Config::addPNCounterConfig, DynamicConfigXmlGenerator::pnCounterXmlGenerator, DynamicConfigYamlGenerator::pnCounterYamlGenerator);
    }

    public static String externalDataStoreConfigGenerator(ExternalDataStoreConfig subConfig, boolean configIsXml, int indent) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.EXTERNAL_DATA_STORE.getName(), Config::addExternalDataStoreConfig, DynamicConfigXmlGenerator::externalDataStoreXmlGenerator, DynamicConfigYamlGenerator::externalDataStoreYamlGenerator);
    }

    public static String tcpIpConfigGenerator(TcpIpConfig subConfig, boolean configIsXml, int indent, boolean advancedNetwork) {
        return DynamicConfigGeneratorUtil.configGenerator(subConfig, configIsXml, indent, ConfigSections.TCP_IP.getName(), (config, tcpIpConfig) -> {
            if (advancedNetwork) {
                config.getAdvancedNetworkConfig().getJoin().setTcpIpConfig((TcpIpConfig)tcpIpConfig);
            } else {
                config.getNetworkConfig().getJoin().setTcpIpConfig((TcpIpConfig)tcpIpConfig);
            }
        }, DynamicConfigXmlGenerator::tcpIpConfigXmlGenerator, DynamicConfigYamlGenerator::tcpIpConfigYamlGenerator);
    }

    private static <T> String configGenerator(T subConfig, boolean configIsXml, int indent, String subConfigTypeName, BiConsumer<Config, T> subConfigAdder, BiConsumer<ConfigXmlGenerator.XmlGenerator, Config> xmlConfigGenerator, BiConsumer<Map<String, Object>, Config> yamlConfigGenerator) {
        String subConfigAsString;
        Config config = new Config();
        subConfigAdder.accept(config, (Config)subConfig);
        if (configIsXml) {
            StringBuilder xml = new StringBuilder();
            ConfigXmlGenerator.XmlGenerator gen = new ConfigXmlGenerator.XmlGenerator(xml);
            xmlConfigGenerator.accept(gen, config);
            subConfigAsString = xml.toString();
            subConfigAsString = XmlUtil.format(subConfigAsString, indent);
        } else {
            LinkedHashMap yaml = new LinkedHashMap();
            yamlConfigGenerator.accept(yaml, config);
            DumpSettings dumpSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setIndicatorIndent(indent - 2).setIndent(indent).build();
            Dump dump = new Dump(dumpSettings);
            subConfigAsString = dump.dumpToString(subConfigTypeName == null ? yaml : yaml.get(subConfigTypeName));
        }
        return subConfigAsString;
    }
}

