/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.enterprise.wan.impl.replication.WanMerkleTreeSyncStats;
import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.monitor.LocalWanPublisherStats;
import com.hazelcast.internal.monitor.LocalWanStats;
import com.hazelcast.internal.monitor.WanSyncState;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.impl.ConsistencyCheckResult;
import com.hazelcast.wan.impl.WanReplicationService;
import com.hazelcast.wan.impl.WanSyncStats;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class WANPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.wan.period.seconds", 0, TimeUnit.SECONDS);
    private static final String WAN_SECTION_NAME = "WAN";
    private static final String UUID_KEY = "uuid";
    private static final String CACHE_EVENT_COUNT_SECTION_PREFIX = "cache";
    private static final String MAP_EVENT_COUNT_SECTION_PREFIX = "map";
    private static final String MAP_CONSISTENCY_CHECK_SECTION_PREFIX = "mapConsistencyCheck";
    private static final String MAP_SYNC_STATS_SECTION_PREFIX = "mapSyncStats";
    private static final String SYNC_EVENT_COUNT_KEY = "syncCount";
    private static final String UPDATE_EVENT_COUNT_KEY = "updateCount";
    private static final String REMOVE_EVENT_COUNT_KEY = "removeCount";
    private static final String DROPPED_EVENT_COUNT_KEY = "droppedCount";
    private static final String CONSISTENCY_CHECK_IS_RUNNING_KEY = "isRunning";
    private static final String CONSISTENCY_CHECK_LAST_CHECKED_COUNT_KEY = "checkedPartitionCount";
    private static final String CONSISTENCY_CHECK_LAST_DIFF_COUNT_KEY = "diffPartitionCount";
    private static final String CONSISTENCY_CHECK_LAST_CHECKED_LEAF_COUNT_KEY = "checkedLeafCount";
    private static final String CONSISTENCY_CHECK_LAST_DIFF_LEAF_COUNT_KEY = "diffLeafCount";
    private static final String CONSISTENCY_CHECK_ENTRIES_TO_SYNC_KEY = "entriesToSync";
    private static final String SYNC_STATS_DURATION = "durationSecs";
    private static final String SYNC_STATS_PARTITIONS = "partitionsSynced";
    private static final String SYNC_STATS_RECORDS = "recordsSynced";
    private static final String MERKLE_SYNC_STATS_NODES = "merkleNodesSynced";
    private static final String MERKLE_SYNC_STATS_AVG_PER_LEAF = "avgRecordsPerMerkleNode";
    private static final String MERKLE_SYNC_STATS_STDDEV_PER_LEAF = "stdDevRecordsPerMerkleNode";
    private static final String MERKLE_SYNC_STATS_MIN_PER_LEAF = "minRecordsPerMerkleNode";
    private static final String MERKLE_SYNC_STATS_MAX_PER_LEAF = "maxRecordsPerMerkleNode";
    private static final String PUBLISHER_OUTBOUND_QUEUE_SIZE_KEY = "outboundQueueSize";
    private static final String PUBLISHER_TOTAL_PUBLISHED_EVENT_COUNT_KEY = "totalPublishedEventCount";
    private static final String PUBLISHER_TOTAL_PUBLISH_LATENCY_KEY = "totalPublishLatency";
    private static final String PUBLISHER_CONNECTED_KEY = "connected";
    private static final String PUBLISHER_STATE_KEY = "state";
    private static final String WAN_SYNC_SECTION_NAME = "syncState";
    private static final String WAN_SYNC_STATUS_KEY = "status";
    private static final String WAN_SYNC_ACTIVE_WAN_CONFIG_NAME_KEY = "activeWanConfigName";
    private static final String WAN_SYNC_ACTIVE_PUBLISHER_NAME_KEY = "activePublisherName";
    private final long periodMillis;
    private final WanReplicationService wanService;

    public WANPlugin(NodeEngineImpl nodeEngine) {
        super(nodeEngine.getLogger(WANPlugin.class));
        HazelcastProperties props = nodeEngine.getProperties();
        this.wanService = nodeEngine.getWanReplicationService();
        this.periodMillis = props.getMillis(PERIOD_SECONDS);
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        writer.startSection(WAN_SECTION_NAME);
        PublisherEventCounts publisherEventCounts = new PublisherEventCounts();
        this.renderReceivedEvents(MAP_EVENT_COUNT_SECTION_PREFIX, writer, this.wanService.getReceivedEventCounters("hz:impl:mapService"), publisherEventCounts);
        this.renderReceivedEvents(CACHE_EVENT_COUNT_SECTION_PREFIX, writer, this.wanService.getReceivedEventCounters("hz:impl:cacheService"), publisherEventCounts);
        writer.writeKeyValueEntry(SYNC_EVENT_COUNT_KEY, publisherEventCounts.totalSyncCount);
        writer.writeKeyValueEntry(UPDATE_EVENT_COUNT_KEY, publisherEventCounts.totalUpdateCount);
        writer.writeKeyValueEntry(REMOVE_EVENT_COUNT_KEY, publisherEventCounts.totalRemoveCount);
        this.renderWanSyncState(writer);
        Map stats = this.wanService.getStats();
        if (stats != null) {
            for (Map.Entry entry : stats.entrySet()) {
                this.renderWanReplication(writer, entry.getKey(), (LocalWanStats)entry.getValue());
            }
        }
        writer.endSection();
    }

    private void renderReceivedEvents(String distributedObjectType, DiagnosticsLogWriter writer, WanEventCounters eventCounter, PublisherEventCounts publisherEventCounts) {
        if (eventCounter != null && !MapUtil.isNullOrEmpty(eventCounter.getEventCounterMap())) {
            for (Map.Entry<String, WanEventCounters.DistributedObjectWanEventCounters> mapCounterEntry : eventCounter.getEventCounterMap().entrySet()) {
                writer.startSection(distributedObjectType + "ReceivedEvents-" + mapCounterEntry.getKey());
                long syncCount = mapCounterEntry.getValue().getSyncCount();
                long updateCount = mapCounterEntry.getValue().getUpdateCount();
                long removeCount = mapCounterEntry.getValue().getRemoveCount();
                publisherEventCounts.totalSyncCount += syncCount;
                publisherEventCounts.totalUpdateCount += updateCount;
                publisherEventCounts.totalRemoveCount += removeCount;
                writer.writeKeyValueEntry(SYNC_EVENT_COUNT_KEY, syncCount);
                writer.writeKeyValueEntry(UPDATE_EVENT_COUNT_KEY, updateCount);
                writer.writeKeyValueEntry(REMOVE_EVENT_COUNT_KEY, removeCount);
                writer.endSection();
            }
        }
    }

    private void renderWanReplication(DiagnosticsLogWriter writer, String wanReplicationConfigName, LocalWanStats stats) {
        Map<String, LocalWanPublisherStats> publisherStats = stats.getLocalWanPublisherStats();
        writer.startSection(wanReplicationConfigName);
        for (Map.Entry<String, LocalWanPublisherStats> publisher : publisherStats.entrySet()) {
            this.renderWanPublisher(writer, publisher.getKey(), publisher.getValue());
        }
        writer.endSection();
    }

    private void renderWanPublisher(DiagnosticsLogWriter writer, String wanPublisherId, LocalWanPublisherStats stats) {
        writer.startSection(wanPublisherId);
        writer.writeKeyValueEntry(PUBLISHER_OUTBOUND_QUEUE_SIZE_KEY, stats.getOutboundQueueSize());
        writer.writeKeyValueEntry(PUBLISHER_TOTAL_PUBLISHED_EVENT_COUNT_KEY, stats.getTotalPublishedEventCount());
        writer.writeKeyValueEntry(PUBLISHER_TOTAL_PUBLISH_LATENCY_KEY, stats.getTotalPublishLatency());
        writer.writeKeyValueEntry(PUBLISHER_CONNECTED_KEY, stats.isConnected());
        writer.writeKeyValueEntry(PUBLISHER_STATE_KEY, stats.getPublisherState().toString());
        PublisherEventCounts publisherEventCounts = new PublisherEventCounts();
        this.renderSentEventCounts(writer, CACHE_EVENT_COUNT_SECTION_PREFIX, stats.getSentCacheEventCounter(), publisherEventCounts);
        this.renderSentEventCounts(writer, MAP_EVENT_COUNT_SECTION_PREFIX, stats.getSentMapEventCounter(), publisherEventCounts);
        writer.writeKeyValueEntry(UPDATE_EVENT_COUNT_KEY, publisherEventCounts.totalUpdateCount);
        writer.writeKeyValueEntry(REMOVE_EVENT_COUNT_KEY, publisherEventCounts.totalRemoveCount);
        writer.writeKeyValueEntry(SYNC_EVENT_COUNT_KEY, publisherEventCounts.totalSyncCount);
        writer.writeKeyValueEntry(DROPPED_EVENT_COUNT_KEY, publisherEventCounts.totalDroppedCount);
        this.renderConsistencyCheckResults(writer, stats.getLastConsistencyCheckResults());
        this.renderSyncStats(writer, stats.getLastSyncStats());
        writer.endSection();
    }

    private void renderConsistencyCheckResults(DiagnosticsLogWriter writer, Map<String, ConsistencyCheckResult> results) {
        if (!MapUtil.isNullOrEmpty(results)) {
            for (Map.Entry<String, ConsistencyCheckResult> comparisonEntry : results.entrySet()) {
                String mapName = comparisonEntry.getKey();
                ConsistencyCheckResult result = comparisonEntry.getValue();
                writer.startSection("mapConsistencyCheck-" + mapName);
                writer.writeKeyValueEntry(UUID_KEY, result.getUuid().toString());
                writer.writeKeyValueEntry(CONSISTENCY_CHECK_IS_RUNNING_KEY, result.isRunning());
                writer.writeKeyValueEntry(CONSISTENCY_CHECK_LAST_CHECKED_COUNT_KEY, result.getLastCheckedPartitionCount());
                writer.writeKeyValueEntry(CONSISTENCY_CHECK_LAST_DIFF_COUNT_KEY, result.getLastDiffPartitionCount());
                writer.writeKeyValueEntry(CONSISTENCY_CHECK_LAST_CHECKED_LEAF_COUNT_KEY, result.getLastCheckedLeafCount());
                writer.writeKeyValueEntry(CONSISTENCY_CHECK_LAST_DIFF_LEAF_COUNT_KEY, result.getLastDiffLeafCount());
                writer.writeKeyValueEntry(CONSISTENCY_CHECK_ENTRIES_TO_SYNC_KEY, result.getLastEntriesToSync());
                writer.endSection();
            }
        }
    }

    private void renderSyncStats(DiagnosticsLogWriter writer, Map<String, WanSyncStats> lastSyncStats) {
        if (!MapUtil.isNullOrEmpty(lastSyncStats)) {
            for (Map.Entry<String, WanSyncStats> syncStatsEntry : lastSyncStats.entrySet()) {
                String mapName = syncStatsEntry.getKey();
                WanSyncStats stats = syncStatsEntry.getValue();
                writer.startSection("mapSyncStats-" + mapName);
                writer.writeKeyValueEntry(UUID_KEY, stats.getUuid().toString());
                writer.writeKeyValueEntry(SYNC_STATS_DURATION, stats.getDurationSecs());
                writer.writeKeyValueEntry(SYNC_STATS_PARTITIONS, stats.getPartitionsSynced());
                writer.writeKeyValueEntry(SYNC_STATS_RECORDS, stats.getRecordsSynced());
                if (stats instanceof WanMerkleTreeSyncStats) {
                    WanMerkleTreeSyncStats merkleStats = (WanMerkleTreeSyncStats)stats;
                    writer.writeKeyValueEntry(MERKLE_SYNC_STATS_NODES, merkleStats.getNodesSynced());
                    writer.writeKeyValueEntry(MERKLE_SYNC_STATS_AVG_PER_LEAF, merkleStats.getAvgEntriesPerLeaf());
                    writer.writeKeyValueEntry(MERKLE_SYNC_STATS_STDDEV_PER_LEAF, merkleStats.getStdDevEntriesPerLeaf());
                    writer.writeKeyValueEntry(MERKLE_SYNC_STATS_MIN_PER_LEAF, merkleStats.getMinLeafEntryCount());
                    writer.writeKeyValueEntry(MERKLE_SYNC_STATS_MAX_PER_LEAF, merkleStats.getMaxLeafEntryCount());
                }
                writer.endSection();
            }
        }
    }

    private void renderSentEventCounts(DiagnosticsLogWriter writer, String distributedObjectType, Map<String, WanEventCounters.DistributedObjectWanEventCounters> sentEventCount, PublisherEventCounts publisherEventCounts) {
        if (!MapUtil.isNullOrEmpty(sentEventCount)) {
            for (Map.Entry<String, WanEventCounters.DistributedObjectWanEventCounters> sentCacheEvents : sentEventCount.entrySet()) {
                WanEventCounters.DistributedObjectWanEventCounters sentEvents = sentCacheEvents.getValue();
                writer.startSection(distributedObjectType + "SentEvents-" + sentCacheEvents.getKey());
                publisherEventCounts.totalUpdateCount += sentEvents.getUpdateCount();
                publisherEventCounts.totalRemoveCount += sentEvents.getRemoveCount();
                publisherEventCounts.totalSyncCount += sentEvents.getSyncCount();
                publisherEventCounts.totalDroppedCount += sentEvents.getDroppedCount();
                writer.writeKeyValueEntry(UPDATE_EVENT_COUNT_KEY, sentEvents.getUpdateCount());
                writer.writeKeyValueEntry(REMOVE_EVENT_COUNT_KEY, sentEvents.getRemoveCount());
                writer.writeKeyValueEntry(SYNC_EVENT_COUNT_KEY, sentEvents.getSyncCount());
                writer.writeKeyValueEntry(DROPPED_EVENT_COUNT_KEY, sentEvents.getDroppedCount());
                writer.endSection();
            }
        }
    }

    private void renderWanSyncState(DiagnosticsLogWriter writer) {
        WanSyncState syncState = this.wanService.getWanSyncState();
        writer.startSection(WAN_SYNC_SECTION_NAME);
        writer.writeKeyValueEntry(WAN_SYNC_STATUS_KEY, syncState.getStatus().toString());
        writer.writeKeyValueEntry(WAN_SYNC_ACTIVE_WAN_CONFIG_NAME_KEY, syncState.getActiveWanConfigName());
        writer.writeKeyValueEntry(WAN_SYNC_ACTIVE_PUBLISHER_NAME_KEY, syncState.getActivePublisherName());
        writer.endSection();
    }

    private static class PublisherEventCounts {
        long totalUpdateCount;
        long totalRemoveCount;
        long totalSyncCount;
        long totalDroppedCount;

        private PublisherEventCounts() {
        }
    }
}

