/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.ClusterVersionAutoUpgradeTask;
import com.hazelcast.internal.cluster.impl.MemberMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.version.Version;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ClusterVersionAutoUpgradeHelper {
    public static final String PROP_AUTO_UPGRADE_ENABLED = "hazelcast.cluster.version.auto.upgrade.enabled";
    public static final String PROP_AUTO_UPGRADE_MIN_CLUSTER_SIZE = "hazelcast.cluster.version.auto.upgrade.min.cluster.size";
    private static final boolean DEFAULT_AUTO_UPGRADE_ENABLED = false;
    private static final int DEFAULT_AUTO_UPGRADE_MIN_CLUSTER_SIZE = 1;
    private static final HazelcastProperty AUTO_UPGRADE_ENABLED = new HazelcastProperty("hazelcast.cluster.version.auto.upgrade.enabled", false);
    private static final HazelcastProperty AUTO_UPGRADE_MIN_CLUSTER_SIZE = new HazelcastProperty("hazelcast.cluster.version.auto.upgrade.min.cluster.size", 1);

    public void scheduleNewAutoUpgradeTask(ClusterServiceImpl clusterService) {
        this.scheduleNewAutoUpgradeTask(0, 0, clusterService);
    }

    void scheduleNewAutoUpgradeTask(int attemptNumber, int delaySeconds, ClusterServiceImpl clusterService) {
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        ILogger logger = nodeEngine.getLogger(ClusterVersionAutoUpgradeHelper.class);
        MemberMap memberMap = this.getCheckedMemberMapOrNull(clusterService, logger);
        if (memberMap != null) {
            this.scheduleTask(attemptNumber, delaySeconds, clusterService, logger);
        }
    }

    private void scheduleTask(int attemptNumber, int delaySeconds, ClusterServiceImpl clusterService, ILogger logger) {
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        ExecutionService executionService = nodeEngine.getExecutionService();
        ClusterVersionAutoUpgradeTask task = new ClusterVersionAutoUpgradeTask(clusterService, attemptNumber, this);
        executionService.schedule("hz:cluster:version:auto:upgrade", task, delaySeconds, TimeUnit.SECONDS);
        ClusterVersionAutoUpgradeHelper.log(logger, Level.INFO, "Cluster version auto upgrade task has been scheduled");
    }

    public MemberMap getCheckedMemberMapOrNull(ClusterServiceImpl clusterService, ILogger logger) {
        HazelcastProperties properties = clusterService.getNodeEngine().getProperties();
        if (!properties.getBoolean(AUTO_UPGRADE_ENABLED)) {
            ClusterVersionAutoUpgradeHelper.log(logger, Level.FINE, "Auto upgrade is not enabled");
            return null;
        }
        if (!clusterService.isMaster()) {
            ClusterVersionAutoUpgradeHelper.log(logger, Level.FINE, "Auto upgrade can only be started by master member");
            return null;
        }
        int minClusterSize = properties.getInteger(AUTO_UPGRADE_MIN_CLUSTER_SIZE);
        MemberMap memberMap = clusterService.getMembershipManager().getMemberMap();
        int currentClusterSize = memberMap.size();
        if (currentClusterSize < minClusterSize) {
            ClusterVersionAutoUpgradeHelper.log(logger, Level.FINE, "Auto upgrade waits to reach minimum cluster size of %s to proceed, now it is %s", minClusterSize, currentClusterSize);
            return null;
        }
        Version currentClusterVersion = clusterService.getClusterVersion();
        if (!ClusterVersionAutoUpgradeHelper.areMemberVersionsGreaterThan(currentClusterVersion, memberMap)) {
            ClusterVersionAutoUpgradeHelper.log(logger, Level.FINE, "All member versions should be greater than current cluster version %s to proceed auto upgrade", currentClusterSize);
            return null;
        }
        return memberMap;
    }

    private static boolean areMemberVersionsGreaterThan(Version currentClusterVersion, MemberMap memberMap) {
        Set<MemberImpl> members = memberMap.getMembers();
        for (MemberImpl member : members) {
            Version memberVersion = member.getVersion().asVersion();
            if (memberVersion.isGreaterThan(currentClusterVersion)) continue;
            return false;
        }
        return true;
    }

    private static void log(ILogger logger, Level level, String msg) {
        ClusterVersionAutoUpgradeHelper.log(logger, level, msg, null);
    }

    private static void log(ILogger logger, Level level, String msg, Object param) {
        if (logger.isLoggable(level)) {
            logger.log(level, param == null ? msg : String.format(msg, param));
        }
    }

    private static void log(ILogger logger, Level level, String msg, Object param1, Object param2) {
        if (logger.isLoggable(level)) {
            logger.log(level, String.format(msg, param1, param2));
        }
    }
}

