/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.HDBTreeInnerNodeAccessor;
import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.NodeSplitStrategy;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import java.util.PrimitiveIterator;

class TStoreBTreeInnerNodeAccessor
extends HDBTreeInnerNodeAccessor {
    private final TStoreAllocator tstoreBtreeAllocator;

    TStoreBTreeInnerNodeAccessor(LockManager lockManager, EnterpriseSerializationService ess, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MemoryAllocator keyAllocator, TStoreAllocator btreeAllocator, int nodeSize, NodeSplitStrategy nodeSplitStrategy, EntrySlotPayload entrySlotPayload) {
        super(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, nodeSplitStrategy, entrySlotPayload);
        this.tstoreBtreeAllocator = btreeAllocator;
    }

    @Override
    int getKeyPartition(Data key) {
        return this.tstoreBtreeAllocator.getKeyPartition(key);
    }

    @Override
    void allocateLogical(long stableAddress) {
        this.tstoreBtreeAllocator.allocateLogical(stableAddress);
    }

    @Override
    boolean isAllocated(long stableAddress) {
        return this.tstoreBtreeAllocator.isAllocated(stableAddress);
    }

    @Override
    long translateToLogical(long stableAddress) {
        return this.tstoreBtreeAllocator.translateToLogical(stableAddress);
    }

    @Override
    protected long translateToPhysical(long stableAddress) {
        return this.tstoreBtreeAllocator.translateToPhysical(stableAddress);
    }

    @Override
    boolean requiresUnlockBeforeNodeDisposal() {
        return false;
    }

    @Override
    long tryLockRecord(int partition, long keyHash) {
        return this.tstoreBtreeAllocator.tryLockRecord(partition, keyHash);
    }

    @Override
    void yield(int partition) {
        this.tstoreBtreeAllocator.yield(partition);
    }

    @Override
    void waitUntilRecordUnlocked(int partition, long keyHash, long cookie) {
        this.tstoreBtreeAllocator.waitUntilRecordUnlocked(partition, keyHash, cookie);
    }

    @Override
    void unlockRecord(int partition, long keyHash, long cookie) {
        this.tstoreBtreeAllocator.unlockRecord(partition, keyHash, cookie);
    }

    @Override
    protected long getLockStateAddr(long stableAddress) {
        return this.tstoreBtreeAllocator.getLockAddress(stableAddress);
    }

    @Override
    void pinAndReplaceLastUnpinned(long stableAddress, LockingContext lockingContext) {
        this.tstoreBtreeAllocator.pinAndReplaceLastUnpinned(stableAddress, lockingContext);
    }

    @Override
    void unpinIfNotLastUnpinned(long stableAddress, LockingContext lockingContext) {
        this.tstoreBtreeAllocator.unpinIfNotLastUnpinned(stableAddress, lockingContext);
    }

    @Override
    void unpin(long stableAddress) {
        this.tstoreBtreeAllocator.unpin(stableAddress);
    }

    @Override
    void ensureReadable(long stableAddress) {
        this.tstoreBtreeAllocator.ensureReadable(stableAddress);
    }

    @Override
    void ensureWritable(long stableAddress) {
        this.tstoreBtreeAllocator.ensureWritable(stableAddress);
    }

    @Override
    void upgradeToWritable(long stableAddress, LockingContext lockingContext) {
        this.tstoreBtreeAllocator.upgradeToWritable(stableAddress, lockingContext);
    }

    @Override
    Data getValue(long nodeAddr, int slot, int partition, Data entryKey) {
        return this.tstoreBtreeAllocator.getRecordValue(partition, entryKey);
    }

    @Override
    long nodeFromLock(long lockAddr) {
        return lockAddr - 8L;
    }

    @Override
    void beforeOperation() {
        TStoreBTreeInnerNodeAccessor.beforeOperation0(this.tstoreBtreeAllocator);
    }

    static void beforeOperation0(TStoreAllocator allocator) {
        allocator.registerEpoch();
    }

    @Override
    void afterOperation(LockingContext lockingContext) {
        TStoreBTreeInnerNodeAccessor.afterOperation0(this.tstoreBtreeAllocator, lockingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void afterOperation0(TStoreAllocator allocator, LockingContext lockingContext) {
        PartitionIdSet partitions = lockingContext.getPartitions();
        if (partitions != null) {
            try {
                PrimitiveIterator.OfInt it = lockingContext.getPartitions().intIterator();
                while (it.hasNext()) {
                    int partitionId = it.next();
                    allocator.unregisterState(partitionId);
                }
            }
            finally {
                lockingContext.clearPartitions();
            }
        }
        allocator.unregisterEpoch();
    }

    @Override
    void beforePartitionOperation(int partitionId, LockingContext lockingContext) {
        TStoreBTreeInnerNodeAccessor.beforePartitionOperation0(this.tstoreBtreeAllocator, partitionId, lockingContext);
    }

    static void beforePartitionOperation0(TStoreAllocator allocator, int partitionId, LockingContext lockingContext) {
        allocator.registerState(partitionId);
        lockingContext.addPartition(partitionId, allocator);
    }

    @Override
    void beforeLock() {
        this.tstoreBtreeAllocator.pauseEpoch();
    }

    @Override
    void afterLock() {
        this.tstoreBtreeAllocator.resumeEpoch();
    }
}

