/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;

class HashIndexKey<T>
implements Comparable<T> {
    private final Comparable indexKey;
    private long indexKeyHash;
    private Data indexKeyData;

    HashIndexKey(Comparable indexKey) {
        this.indexKey = indexKey;
    }

    Comparable getIndexKey() {
        return this.indexKey;
    }

    long getIndexKeyHash(EnterpriseSerializationService ess) {
        if (this.indexKeyHash == 0L) {
            this.indexKeyHash = this.getIndexKeyData(ess).hash64();
        }
        return this.indexKeyHash;
    }

    Data getIndexKeyData(EnterpriseSerializationService ess) {
        if (this.indexKeyData == null) {
            this.indexKeyData = ess.toData((Object)this.indexKey, DataType.HEAP);
        }
        return this.indexKeyData;
    }

    @Override
    public int compareTo(T o) {
        return this.indexKey.compareTo(o);
    }

    public boolean equals(Object o) {
        return o instanceof HashIndexKey && this.indexKey.equals(((HashIndexKey)o).indexKey);
    }

    public int hashCode() {
        return this.indexKey.hashCode();
    }
}

