/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.query.impl.Comparables;

public class DefaultBPlusTreeKeyComparator
implements BPlusTreeKeyComparator {
    private final EnterpriseSerializationService ess;
    private final ThreadLocal<NativeMemoryData> rightDataHolder = new ThreadLocal<NativeMemoryData>(){

        @Override
        protected NativeMemoryData initialValue() {
            return new NativeMemoryData();
        }
    };

    public DefaultBPlusTreeKeyComparator(EnterpriseSerializationService ess) {
        this.ess = ess;
    }

    @Override
    public int compare(Comparable left, long rightAddress, long rightPayload) {
        NativeMemoryData rightData = this.rightDataHolder.get();
        rightData.reset(rightAddress);
        Comparable right = null;
        if (rightData.totalSize() > 0) {
            right = (Comparable)this.ess.toObject(rightData);
        }
        if (left == null && right == null) {
            return 0;
        }
        if (left != null && right != null) {
            return Comparables.compare(left, right);
        }
        if (left == null) {
            return -1;
        }
        return 1;
    }
}

