/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.enterprise.wan.impl.DistributedObjectEntryIdentifier;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.map.impl.wan.WanEnterpriseMapMerkleTreeNode;
import com.hazelcast.map.impl.wan.WanEnterpriseMapSyncEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WanEventBatch
implements IdentifiedDataSerializable {
    private transient boolean snapshotEnabled;
    private transient Map<DistributedObjectEntryIdentifier, InternalWanEvent> eventMap;
    private transient List<InternalWanEvent> coalescedEvents;
    private transient int primaryEventCount;
    private transient int totalEntryCount;
    private List<Schema> compactSchemas;
    private Collection<InternalWanEvent> eventList;

    public WanEventBatch() {
    }

    public WanEventBatch(boolean snapshotEnabled) {
        this.snapshotEnabled = snapshotEnabled;
        if (snapshotEnabled) {
            this.eventMap = new HashMap<DistributedObjectEntryIdentifier, InternalWanEvent>();
            this.coalescedEvents = new LinkedList<InternalWanEvent>();
        } else {
            this.eventList = new ArrayList<InternalWanEvent>();
            this.coalescedEvents = Collections.emptyList();
        }
    }

    public void addEvent(InternalWanEvent event) {
        boolean isCoalesced = false;
        if (this.snapshotEnabled) {
            DistributedObjectEntryIdentifier id = this.getDistributedObjectEntryIdentifier(event);
            InternalWanEvent coalescedEvent = this.eventMap.put(id, event);
            if (coalescedEvent != null) {
                this.coalescedEvents.add(coalescedEvent);
                isCoalesced = true;
            }
        } else {
            this.eventList.add(event);
        }
        if (!isCoalesced) {
            this.incrementEventCount(event);
        }
        if (!(event instanceof WanEnterpriseMapMerkleTreeNode) && !(event instanceof WanEnterpriseMapSyncEvent)) {
            ++this.primaryEventCount;
        }
    }

    private void incrementEventCount(InternalWanEvent eventObject) {
        if (eventObject instanceof WanEnterpriseMapMerkleTreeNode) {
            WanEnterpriseMapMerkleTreeNode node = (WanEnterpriseMapMerkleTreeNode)eventObject;
            this.totalEntryCount += node.getEntryCount();
        } else {
            ++this.totalEntryCount;
        }
    }

    private DistributedObjectEntryIdentifier getDistributedObjectEntryIdentifier(InternalWanEvent event) {
        return new DistributedObjectEntryIdentifier(event.getServiceName(), event.getObjectName(), event.getKey());
    }

    public int getPrimaryEventCount() {
        return this.primaryEventCount;
    }

    public int getTotalEntryCount() {
        return this.totalEntryCount;
    }

    public List<InternalWanEvent> getCoalescedEvents() {
        return this.coalescedEvents;
    }

    public Collection<InternalWanEvent> getEvents() {
        if (this.snapshotEnabled) {
            return this.eventMap == null ? Collections.emptyList() : this.eventMap.values();
        }
        return this.eventList == null ? Collections.emptyList() : this.eventList;
    }

    public void setCompactSchemas(List<Schema> compactSchemas) {
        this.compactSchemas = compactSchemas;
    }

    public List<Schema> getCompactSchemas() {
        return this.compactSchemas;
    }

    public boolean isEmpty() {
        return this.getTotalEntryCount() == 0;
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeCollection(this.getEvents(), out);
        if (out.getWanProtocolVersion().isGreaterOrEqual(EnterpriseWanReplicationService.COMPACT_SUPPORTED_WAN_PROTOCOL_VERSION)) {
            SerializationUtil.writeNullableList(this.compactSchemas, out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.eventList = SerializationUtil.readCollection(in);
        if (in.getWanProtocolVersion().isGreaterOrEqual(EnterpriseWanReplicationService.COMPACT_SUPPORTED_WAN_PROTOCOL_VERSION)) {
            this.compactSchemas = SerializationUtil.readNullableList(in);
        }
    }
}

