/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class MerkleTreeNodeValueComparison
implements IdentifiedDataSerializable {
    private Map<Integer, int[]> merkleTreeNodeValues = Collections.emptyMap();

    public MerkleTreeNodeValueComparison() {
    }

    public MerkleTreeNodeValueComparison(Map<Integer, int[]> merkleTreeNodeValues) {
        this.merkleTreeNodeValues = merkleTreeNodeValues;
    }

    public int[] getMerkleTreeNodeValues(int partitionId) {
        return this.merkleTreeNodeValues.get(partitionId);
    }

    public Set<Integer> getPartitionIds() {
        return this.merkleTreeNodeValues.keySet();
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 18;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.merkleTreeNodeValues.size());
        for (Map.Entry<Integer, int[]> partitionNodes : this.merkleTreeNodeValues.entrySet()) {
            out.writeInt(partitionNodes.getKey());
            out.writeIntArray(partitionNodes.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int partitionCount = in.readInt();
        this.merkleTreeNodeValues = MapUtil.createHashMap(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            this.merkleTreeNodeValues.put(in.readInt(), in.readIntArray());
        }
    }
}

