/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.AbstractWanEventRunnable;
import com.hazelcast.enterprise.wan.impl.WanAcknowledger;
import com.hazelcast.enterprise.wan.impl.operation.WanEventContainerOperation;
import com.hazelcast.internal.services.WanSupportingService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.util.Set;

class WanEventRunnable
extends AbstractWanEventRunnable {
    private final InternalWanEvent event;
    private final NodeEngine nodeEngine;
    private final Set<Operation> liveOperations;
    private final ILogger logger;
    private final WanAcknowledger acknowledger;

    WanEventRunnable(InternalWanEvent event, WanEventContainerOperation operation, NodeEngine nodeEngine, Set<Operation> liveOperations, ILogger logger, WanAcknowledger acknowledger) {
        super(operation);
        this.event = event;
        this.nodeEngine = nodeEngine;
        this.liveOperations = liveOperations;
        this.logger = logger;
        this.acknowledger = acknowledger;
    }

    @Override
    public void run() {
        try {
            String serviceName = this.event.getServiceName();
            WanSupportingService service = (WanSupportingService)this.nodeEngine.getService(serviceName);
            service.onReplicationEvent(this.event, this.operation.getAcknowledgeType());
            this.acknowledger.acknowledgeSuccess(this.operation);
        }
        catch (Exception e) {
            this.acknowledger.acknowledgeFailure(this.operation);
            this.log(this.logger, e);
        }
        finally {
            if (!this.liveOperations.remove(this.operation)) {
                this.logger.warning("Did not remove WanOperation from live operation list. Possible memory leak!");
            }
        }
    }
}

