/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventPublishOperation;
import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventResult;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.wan.impl.WanAntiEntropyEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;

public abstract class AbstractWanAntiEntropyEvent
implements IdentifiedDataSerializable,
WanAntiEntropyEvent {
    protected UUID uuid;
    protected String mapName;
    protected Set<Integer> partitionSet = Collections.emptySet();
    private transient WanAntiEntropyEventPublishOperation op;
    private transient WanAntiEntropyEventResult processingResult;

    public AbstractWanAntiEntropyEvent() {
    }

    public AbstractWanAntiEntropyEvent(String mapName) {
        this.assignUuid();
        this.mapName = mapName;
    }

    protected AbstractWanAntiEntropyEvent(UUID uuid) {
        this.uuid = uuid;
    }

    protected AbstractWanAntiEntropyEvent(UUID uuid, String mapName) {
        this.uuid = uuid;
        this.mapName = mapName;
    }

    protected void assignUuid() {
        this.uuid = UuidUtil.newUnsecureUUID();
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getObjectName() {
        return this.mapName;
    }

    @Override
    public Set<Integer> getPartitionSet() {
        return this.partitionSet;
    }

    public void setPartitionSet(Set<Integer> partitionSet) {
        this.partitionSet = partitionSet;
    }

    public WanAntiEntropyEventPublishOperation getOp() {
        return this.op;
    }

    public void setOp(WanAntiEntropyEventPublishOperation op) {
        this.op = op;
    }

    public WanAntiEntropyEventResult getProcessingResult() {
        return this.processingResult;
    }

    public void setProcessingResult(WanAntiEntropyEventResult processingResult) {
        this.processingResult = processingResult;
    }

    public void sendResponse() {
        try {
            this.op.sendResponse(this.processingResult);
        }
        catch (Exception ex) {
            this.op.getNodeEngine().getLogger(AbstractWanAntiEntropyEvent.class).warning(ex);
        }
    }

    public abstract AbstractWanAntiEntropyEvent cloneWithoutPartitionKeys();

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        out.writeString(this.mapName);
        out.writeInt(this.partitionSet.size());
        for (Integer partitionId : this.partitionSet) {
            out.writeInt(partitionId);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.mapName = in.readString();
        int size = in.readInt();
        this.partitionSet = SetUtil.createHashSet(size);
        for (int i = 0; i < size; ++i) {
            this.partitionSet.add(in.readInt());
        }
    }
}

