/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.datastore.impl;

import com.hazelcast.spi.annotation.Beta;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

@Beta
public abstract class CloseableDataSource
implements DataSource,
AutoCloseable {
    private final DataSource dataSource;

    private CloseableDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    public static CloseableDataSource closing(final DataSource dataSource) {
        return new CloseableDataSource(dataSource){

            @Override
            public void close() throws Exception {
                if (dataSource instanceof AutoCloseable) {
                    ((AutoCloseable)((Object)dataSource)).close();
                }
            }
        };
    }

    public static CloseableDataSource nonClosing(DataSource dataSource) {
        return new CloseableDataSource(dataSource){

            @Override
            public void close() {
            }
        };
    }
}

