/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotEntry;
import com.hazelcast.cp.internal.raft.impl.persistence.LogFileStructure;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class RestoredLogFile {
    private final String filename;
    private final long topIndex;
    private final SnapshotEntry snapshotEntry;
    private final LogEntry[] entries;
    private final long[] entryOffsets;

    RestoredLogFile(@Nonnull String filename, long topIndex) {
        this.filename = filename;
        this.topIndex = topIndex;
        this.snapshotEntry = null;
        this.entries = null;
        this.entryOffsets = null;
    }

    RestoredLogFile(@Nonnull String filename, @Nullable SnapshotEntry snapshotEntry, @Nonnull LogEntry[] entries, @Nonnull long[] entryOffsets, long topIndex) {
        this.filename = filename;
        this.topIndex = topIndex;
        this.snapshotEntry = snapshotEntry;
        this.entries = entries;
        this.entryOffsets = entryOffsets;
    }

    @Nonnull
    LoadMode loadMode() {
        return this.entries != null ? LoadMode.FULL : LoadMode.JUST_TOP_INDEX;
    }

    long topIndex() {
        return this.topIndex;
    }

    @Nullable
    SnapshotEntry snapshotEntry() {
        return this.snapshotEntry;
    }

    @Nonnull
    LogEntry[] entries() {
        if (this.entries == null) {
            throw new IllegalStateException("This RestoredLogFile wasn't loaded in the FULL mode");
        }
        return this.entries;
    }

    @Nonnull
    String filename() {
        return this.filename;
    }

    @Nonnull
    LogFileStructure toLogFileStructure() {
        if (this.entryOffsets == null) {
            throw new IllegalStateException("This RestoredLogFile wasn't loaded in the FULL mode");
        }
        return new LogFileStructure(this.filename, this.entryOffsets, this.topIndex - (long)this.entryOffsets.length + 1L);
    }

    static enum LoadMode {
        FULL,
        JUST_TOP_INDEX;

    }
}

