/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cp.internal.raft.impl.persistence.LogFileStructure;
import javax.annotation.Nonnull;

class LogEntryRingBuffer {
    private final long[] offsets;
    private long bottomEntryIndex;
    private int bufLen;

    LogEntryRingBuffer(int capacity) {
        this.offsets = new long[capacity];
        this.bottomEntryIndex = 1L;
    }

    LogEntryRingBuffer(int capacity, long firstEntryIndex) {
        this.offsets = new long[capacity];
        this.bottomEntryIndex = firstEntryIndex;
    }

    LogEntryRingBuffer(int size, @Nonnull LogFileStructure logFileStructure) {
        this.offsets = new long[size];
        this.importEntryOffsets(logFileStructure);
    }

    long topIndex() {
        return this.bottomEntryIndex + (long)this.bufLen - 1L;
    }

    void addEntryOffset(long offset) {
        int insertionPoint = (int)((this.bottomEntryIndex + (long)this.bufLen) % (long)this.offsets.length);
        this.offsets[insertionPoint] = offset;
        if (this.bufLen == this.offsets.length) {
            ++this.bottomEntryIndex;
        } else {
            ++this.bufLen;
        }
    }

    long getEntryOffset(long entryIndex) {
        if (entryIndex < this.bottomEntryIndex || entryIndex > this.topIndex()) {
            throw new IndexOutOfBoundsException(String.format("Asked for entry index %,d, available range is [%,d..%,d]", entryIndex, this.bottomEntryIndex, this.topIndex()));
        }
        int idx = (int)(entryIndex % (long)this.offsets.length);
        return this.offsets[idx];
    }

    long deleteEntriesFrom(long deletionStartIndex) {
        long offsetAtDeletionStart = this.getEntryOffset(deletionStartIndex);
        long newBufLen = deletionStartIndex - this.bottomEntryIndex;
        this.bufLen = (int)Math.max(0L, Math.min((long)this.bufLen, newBufLen));
        return offsetAtDeletionStart;
    }

    void adjustToNewFile(long newStartOffset, long snapshotIndex) {
        if (this.bufLen > 0 && snapshotIndex < this.bottomEntryIndex) {
            throw new IndexOutOfBoundsException(String.format("Snapshot index %,d is less than the lowest entry index in the buffer %,d", snapshotIndex, this.bottomEntryIndex));
        }
        long newBottomIndex = snapshotIndex + 1L;
        int indexDelta = (int)(newBottomIndex - this.bottomEntryIndex);
        this.bottomEntryIndex = newBottomIndex;
        this.bufLen -= indexDelta;
        if (this.bufLen <= 0) {
            this.bufLen = 0;
            return;
        }
        this.adjustOffsets(newStartOffset);
    }

    @Nonnull
    long[] exportEntryOffsets() {
        int startIndex;
        long[] result = new long[this.bufLen];
        int[] startAndEndIndex = this.startAndEndIndex();
        int endIndex = startAndEndIndex[1];
        if (endIndex >= (startIndex = startAndEndIndex[0])) {
            System.arraycopy(this.offsets, startIndex, result, 0, this.bufLen);
        } else {
            int firstPartLen = this.offsets.length - startIndex;
            System.arraycopy(this.offsets, startIndex, result, 0, firstPartLen);
            System.arraycopy(this.offsets, 0, result, firstPartLen, this.bufLen - firstPartLen);
        }
        return result;
    }

    private void importEntryOffsets(LogFileStructure logFileStructure) {
        int startIndex;
        this.bottomEntryIndex = logFileStructure.indexOfFirstTailEntry();
        long[] offsetsToImport = logFileStructure.tailEntryOffsets();
        this.bufLen = offsetsToImport.length;
        if (this.bufLen > this.offsets.length) {
            throw new IllegalArgumentException(String.format("Specified ring buffer capacity %,d is less than the number of offsets to import %,d.", this.offsets.length, this.bufLen));
        }
        if (this.bufLen == 0) {
            return;
        }
        int[] startAndEndIndex = this.startAndEndIndex();
        int endIndex = startAndEndIndex[1];
        if (endIndex >= (startIndex = startAndEndIndex[0])) {
            System.arraycopy(offsetsToImport, 0, this.offsets, startIndex, offsetsToImport.length);
        } else {
            int firstPartLen = this.offsets.length - startIndex;
            System.arraycopy(offsetsToImport, 0, this.offsets, startIndex, firstPartLen);
            System.arraycopy(offsetsToImport, firstPartLen, this.offsets, 0, offsetsToImport.length - firstPartLen);
        }
    }

    private void adjustOffsets(long newStartOffset) {
        long startIndexLong = this.bottomEntryIndex % (long)this.offsets.length;
        int startIndex = (int)startIndexLong;
        int limitIndex = (int)(startIndexLong + (long)this.bufLen);
        long offsetDelta = newStartOffset - this.offsets[startIndex];
        for (int i = startIndex; i != limitIndex; ++i) {
            int n = i % this.offsets.length;
            this.offsets[n] = this.offsets[n] + offsetDelta;
        }
    }

    private int[] startAndEndIndex() {
        long startIndexLong = this.bottomEntryIndex % (long)this.offsets.length;
        long endIndexLong = (startIndexLong + (long)this.bufLen - 1L) % (long)this.offsets.length;
        return new int[]{(int)startIndexLong, (int)endIndexLong};
    }
}

