/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cp.internal.persistence.BufferedRaf;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

final class FileIOSupport {
    static final String TMP_SUFFIX = ".tmp";

    private FileIOSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeWithChecksum(File baseDir, String filename, InternalSerializationService serializationService, Writable writable) throws IOException {
        File tmpFile = new File(baseDir, filename + TMP_SUFFIX);
        BufferedRaf bufRaf = new BufferedRaf(new RandomAccessFile(tmpFile, "rw"));
        BufferedRaf.BufRafObjectDataOut out = bufRaf.asObjectDataOutputStream(serializationService);
        try {
            writable.writeTo(out);
            out.writeCrc32();
            out.flush();
            bufRaf.force();
        }
        finally {
            IOUtil.closeResource(out);
        }
        IOUtil.rename(tmpFile, new File(baseDir, filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T readWithChecksum(File baseDir, String filename, InternalSerializationService serializationService, Readable<T> readable) throws IOException {
        File f = new File(baseDir, filename);
        if (!f.exists()) {
            return null;
        }
        BufferedRaf raf = new BufferedRaf(new RandomAccessFile(f, "r"));
        BufferedRaf.BufRafObjectDataIn in = raf.asObjectDataInputStream(serializationService);
        try {
            T result = readable.readFrom(in);
            in.checkCrc32();
            T t = result;
            return t;
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    static interface Readable<T> {
        public T readFrom(ObjectDataInput var1) throws IOException;
    }

    static interface Writable {
        public void writeTo(ObjectDataOutput var1) throws IOException;
    }
}

