/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientLocalBackupListenerCodec;
import com.hazelcast.client.impl.spi.ClientInvocationService;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientResponseHandlerSupplier;
import com.hazelcast.client.impl.spi.impl.InvocationMightContainCompactDataException;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.sequence.CallIdFactory;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ClientInvocationServiceImpl
implements ClientInvocationService {
    private static final ListenerMessageCodec BACKUP_LISTENER = new ListenerMessageCodec(){

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return ClientLocalBackupListenerCodec.encodeRequest();
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return ClientLocalBackupListenerCodec.decodeResponse(clientMessage);
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return null;
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return false;
        }
    };
    private static final HazelcastProperty CLEAN_RESOURCES_MILLIS = new HazelcastProperty("hazelcast.client.internal.clean.resources.millis", 100, TimeUnit.MILLISECONDS);
    final HazelcastClientInstanceImpl client;
    final ILogger invocationLogger;
    private volatile boolean isShutdown;
    @Probe(name="pendingCalls", level=ProbeLevel.MANDATORY)
    private final ConcurrentMap<Long, ClientInvocation> invocations = new ConcurrentHashMap<Long, ClientInvocation>();
    private final ClientResponseHandlerSupplier responseHandlerSupplier;
    private final long invocationTimeoutMillis;
    private final long invocationRetryPauseMillis;
    private final CallIdSequence callIdSequence;
    private final boolean shouldFailOnIndeterminateOperationState;
    private final int operationBackupTimeoutMillis;
    private final boolean isBackupAckToClientEnabled;
    private final ClientConnectionManager connectionManager;
    private final ClientPartitionService partitionService;
    private final boolean isSmartRoutingEnabled;

    public ClientInvocationServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.invocationLogger = client.getLoggingService().getLogger(ClientInvocationService.class);
        this.invocationTimeoutMillis = this.initInvocationTimeoutMillis();
        this.invocationRetryPauseMillis = this.initInvocationRetryPauseMillis();
        this.responseHandlerSupplier = new ClientResponseHandlerSupplier(this, client.getConcurrencyDetection());
        HazelcastProperties properties = client.getProperties();
        this.callIdSequence = CallIdFactory.newCallIdSequence(properties.getInteger(ClientProperty.MAX_CONCURRENT_INVOCATIONS), properties.getLong(ClientProperty.BACKPRESSURE_BACKOFF_TIMEOUT_MILLIS), client.getConcurrencyDetection());
        this.operationBackupTimeoutMillis = properties.getInteger(ClientProperty.OPERATION_BACKUP_TIMEOUT_MILLIS);
        this.shouldFailOnIndeterminateOperationState = properties.getBoolean(ClientProperty.FAIL_ON_INDETERMINATE_OPERATION_STATE);
        client.getMetricsRegistry().registerStaticMetrics(this, "invocations");
        this.isSmartRoutingEnabled = client.getClientConfig().getNetworkConfig().isSmartRouting();
        this.isBackupAckToClientEnabled = this.isSmartRoutingEnabled && client.getClientConfig().isBackupAckToClientEnabled();
        this.connectionManager = client.getConnectionManager();
        this.partitionService = client.getClientPartitionService();
    }

    private long initInvocationRetryPauseMillis() {
        return this.client.getProperties().getPositiveMillisOrDefault(ClientProperty.INVOCATION_RETRY_PAUSE_MILLIS);
    }

    private long initInvocationTimeoutMillis() {
        return this.client.getProperties().getPositiveMillisOrDefault(ClientProperty.INVOCATION_TIMEOUT_SECONDS);
    }

    @Probe(name="startedInvocations", level=ProbeLevel.MANDATORY)
    private long startedInvocations() {
        return this.callIdSequence.getLastCallId();
    }

    @Probe(name="maxCurrentInvocations", level=ProbeLevel.MANDATORY)
    private long maxCurrentInvocations() {
        return this.callIdSequence.getMaxConcurrentInvocations();
    }

    public long getInvocationTimeoutMillis() {
        return this.invocationTimeoutMillis;
    }

    public long getInvocationRetryPauseMillis() {
        return this.invocationRetryPauseMillis;
    }

    CallIdSequence getCallIdSequence() {
        return this.callIdSequence;
    }

    public void addBackupListener() {
        if (this.isBackupAckToClientEnabled) {
            ClientListenerService listenerService = this.client.getListenerService();
            listenerService.registerListener(BACKUP_LISTENER, new BackupEventHandler());
        }
    }

    public void start() {
        this.responseHandlerSupplier.start();
        if (this.isBackupAckToClientEnabled) {
            TaskScheduler executionService = this.client.getTaskScheduler();
            long cleanResourcesMillis = this.client.getProperties().getPositiveMillisOrDefault(CLEAN_RESOURCES_MILLIS);
            executionService.scheduleWithRepetition(new BackupTimeoutTask(), cleanResourcesMillis, cleanResourcesMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public boolean invokeOnPartitionOwner(ClientInvocation invocation, int partitionId) {
        UUID partitionOwner = this.partitionService.getPartitionOwner(partitionId);
        if (partitionOwner == null) {
            if (this.invocationLogger.isFinestEnabled()) {
                this.invocationLogger.finest("Partition owner is not assigned yet");
            }
            return false;
        }
        return this.invokeOnTarget(invocation, partitionOwner);
    }

    @Override
    public boolean invoke(ClientInvocation invocation) {
        ClientConnection connection = this.connectionManager.getRandomConnection();
        if (connection == null) {
            if (this.invocationLogger.isFinestEnabled()) {
                this.invocationLogger.finest("No connection found to invoke");
            }
            return false;
        }
        return this.send(invocation, connection);
    }

    @Override
    public boolean invokeOnTarget(ClientInvocation invocation, UUID uuid) {
        assert (uuid != null);
        ClientConnection connection = this.connectionManager.getConnection(uuid);
        if (connection == null) {
            if (this.invocationLogger.isFinestEnabled()) {
                this.invocationLogger.finest("Client is not connected to target : " + uuid);
            }
            return false;
        }
        return this.send(invocation, connection);
    }

    @Override
    public boolean invokeOnConnection(ClientInvocation invocation, ClientConnection connection) {
        return this.send(invocation, connection);
    }

    @Override
    public Consumer<ClientMessage> getResponseHandler() {
        return this.responseHandlerSupplier.get();
    }

    @Override
    public void onConnectionClose(ClientConnection connection) {
        for (ClientInvocation invocation : this.invocations.values()) {
            if (!invocation.getPermissionToNotifyForDeadConnection(connection)) continue;
            TargetDisconnectedException ex = new TargetDisconnectedException(connection.getCloseReason(), connection.getCloseCause());
            invocation.notifyExceptionWithOwnedPermission(ex);
        }
    }

    @Override
    public boolean isRedoOperation() {
        return this.client.getClientConfig().getNetworkConfig().isRedoOperation();
    }

    private boolean send(ClientInvocation invocation, ClientConnection connection) {
        if (this.isShutdown) {
            throw new HazelcastClientNotActiveException();
        }
        ClientMessage clientMessage = invocation.getClientMessage();
        if (this.isBackupAckToClientEnabled) {
            clientMessage.getStartFrame().flags |= 0x100;
        }
        this.registerInvocation(invocation, connection);
        invocation.setSentConnection(connection);
        if (!connection.write(clientMessage)) {
            if (invocation.getPermissionToNotifyForDeadConnection(connection)) {
                IOException exception = new IOException("Packet not sent to " + connection.getRemoteAddress() + " " + clientMessage);
                invocation.notifyExceptionWithOwnedPermission(exception);
            }
        } else {
            invocation.invoked();
        }
        return true;
    }

    void registerInvocation(ClientInvocation clientInvocation, ClientConnection connection) {
        ClientMessage clientMessage = clientInvocation.getClientMessage();
        long correlationId = clientMessage.getCorrelationId();
        this.invocations.put(correlationId, clientInvocation);
        EventHandler handler = clientInvocation.getEventHandler();
        if (handler != null) {
            connection.addEventHandler(correlationId, handler);
        }
    }

    void deRegisterInvocation(long callId) {
        this.invocations.remove(callId);
    }

    ClientInvocation getInvocation(long callId) {
        return (ClientInvocation)this.invocations.get(callId);
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public void shutdown() {
        this.isShutdown = true;
        this.responseHandlerSupplier.shutdown();
        for (ClientInvocation invocation : this.invocations.values()) {
            invocation.notifyExceptionWithOwnedPermission(new HazelcastClientNotActiveException());
        }
    }

    void checkInvocationAllowed() throws IOException {
        this.connectionManager.checkInvocationAllowed();
    }

    void checkUrgentInvocationAllowed(ClientInvocation invocation) {
        if (this.connectionManager.clientInitializedOnCluster()) {
            return;
        }
        if (!this.client.shouldCheckUrgentInvocations()) {
            return;
        }
        if (invocation.getClientMessage().isContainsSerializedDataInRequest()) {
            throw new InvocationMightContainCompactDataException(invocation);
        }
    }

    boolean shouldFailOnIndeterminateOperationState() {
        return this.shouldFailOnIndeterminateOperationState;
    }

    public boolean isSmartRoutingEnabled() {
        return this.isSmartRoutingEnabled;
    }

    public class BackupEventHandler
    extends ClientLocalBackupListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        @Override
        public void handleBackupEvent(long sourceInvocationCorrelationId) {
            ClientInvocation invocation = ClientInvocationServiceImpl.this.getInvocation(sourceInvocationCorrelationId);
            if (invocation == null) {
                if (ClientInvocationServiceImpl.this.invocationLogger.isFinestEnabled()) {
                    ClientInvocationServiceImpl.this.invocationLogger.finest("Invocation not found for backup event, invocation id " + sourceInvocationCorrelationId);
                }
                return;
            }
            invocation.notifyBackupComplete();
        }
    }

    private class BackupTimeoutTask
    implements Runnable {
        private BackupTimeoutTask() {
        }

        @Override
        public void run() {
            for (ClientInvocation invocation : ClientInvocationServiceImpl.this.invocations.values()) {
                invocation.detectAndHandleBackupTimeout(ClientInvocationServiceImpl.this.operationBackupTimeoutMillis);
            }
        }
    }
}

