/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.QueueStoreConfigHolder;
import com.hazelcast.internal.serialization.Data;
import java.util.Map;

public final class QueueStoreConfigHolderCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 1;

    private QueueStoreConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, QueueStoreConfigHolder queueStoreConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[1]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, queueStoreConfigHolder.isEnabled());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, queueStoreConfigHolder.getClassName(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, queueStoreConfigHolder.getFactoryClassName(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, queueStoreConfigHolder.getImplementation(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, queueStoreConfigHolder.getFactoryImplementation(), DataCodec::encode);
        MapCodec.encodeNullable(clientMessage, queueStoreConfigHolder.getProperties(), StringCodec::encode, StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static QueueStoreConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        String className = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        String factoryClassName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        Data implementation = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Data factoryImplementation = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Map<String, String> properties = MapCodec.decodeNullable(iterator, StringCodec::decode, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new QueueStoreConfigHolder(className, factoryClassName, implementation, factoryImplementation, properties, enabled);
    }
}

