/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheDataSerializerHook;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CacheSetExpiryPolicyBackupOperation
extends HiDensityCacheOperation
implements MutableOperation,
MutatingOperation {
    private transient boolean atLeastOneSucceeded;
    private List<Data> keys;
    private Data expiryPolicy;

    public CacheSetExpiryPolicyBackupOperation() {
    }

    public CacheSetExpiryPolicyBackupOperation(String name, List<Data> keys, Data expiryPolicy) {
        super(name);
        this.keys = keys;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    protected void runInternal() {
        if (this.recordStore == null) {
            return;
        }
        this.recordStore.setExpiryPolicy(this.keys, this.expiryPolicy, this.getCallerUuid());
        this.atLeastOneSucceeded = true;
    }

    @Override
    public void afterRun() throws Exception {
        if (this.recordStore.isWanReplicationEnabled()) {
            for (Data key : this.keys) {
                CacheRecord record = this.recordStore.getRecord(key);
                this.publishWanUpdate(key, record);
            }
        }
        super.afterRun();
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        super.disposeInternal(serializationService);
        if (!this.atLeastOneSucceeded) {
            serializationService.disposeData(this.expiryPolicy);
        }
    }

    @Override
    public int getFactoryId() {
        return HiDensityCacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 28;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            IOUtil.writeData(out, key);
        }
        IOUtil.writeData(out, this.expiryPolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int s = in.readInt();
        this.keys = new ArrayList<Data>(s);
        while (s-- > 0) {
            this.keys.add(IOUtil.readData(in));
        }
        this.expiryPolicy = IOUtil.readData(in);
    }
}

