/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.operation.BackupAwareKeyBasedHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CachePutBackupOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class CacheReplaceOperation
extends BackupAwareKeyBasedHiDensityCacheOperation
implements MutableOperation,
MutatingOperation {
    private Data value;
    private Data currentValue;
    private ExpiryPolicy expiryPolicy;

    public CacheReplaceOperation() {
    }

    public CacheReplaceOperation(String name, Data key, Data oldValue, Data newValue, ExpiryPolicy expiryPolicy) {
        super(name, key);
        this.value = newValue;
        this.currentValue = oldValue;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    protected void runInternal() {
        HiDensityCacheRecordStore hdCache = (HiDensityCacheRecordStore)this.recordStore;
        this.response = this.currentValue == null ? Boolean.valueOf(hdCache.replace(this.key, (Object)this.value, this.expiryPolicy, this.getCallerUuid(), this.completionId)) : Boolean.valueOf(hdCache.replace(this.key, this.currentValue, this.value, this.expiryPolicy, this.getCallerUuid(), this.completionId));
    }

    @Override
    public void afterRun() throws Exception {
        if (Boolean.TRUE.equals(this.response)) {
            this.publishWanUpdate(this.key, this.recordStore.getRecord(this.key));
        }
        super.afterRun();
        this.dispose();
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        serializationService.disposeData(this.key);
        if (!Boolean.TRUE.equals(this.response)) {
            serializationService.disposeData(this.value);
        }
        if (this.currentValue != null) {
            serializationService.disposeData(this.currentValue);
        }
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response) && this.recordStore.getRecord(this.key) != null;
    }

    @Override
    public Operation getBackupOperation() {
        CacheRecord record = this.recordStore.getRecord(this.key);
        return new CachePutBackupOperation(this.name, this.key, this.value, this.expiryPolicy, record.getCreationTime());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.value);
        IOUtil.writeData(out, this.currentValue);
        out.writeObject(this.expiryPolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.value = CacheReplaceOperation.readNativeMemoryOperationData(in);
        this.currentValue = CacheReplaceOperation.readNativeMemoryOperationData(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
    }

    @Override
    public int getClassId() {
        return 6;
    }
}

