/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecord;
import com.hazelcast.cache.impl.hidensity.operation.BackupAwareKeyBasedHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CacheBackupRecordStore;
import com.hazelcast.cache.impl.hidensity.operation.CachePutAllBackupOperation;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheOperation;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.cache.CacheException;

public class CacheLoadAllOperation
extends BackupAwareKeyBasedHiDensityCacheOperation
implements MutatingOperation {
    private Set<Data> keys;
    private boolean replaceExistingValues;
    private boolean shouldBackup;
    private transient CacheBackupRecordStore cacheBackupRecordStore;

    public CacheLoadAllOperation() {
    }

    public CacheLoadAllOperation(String name, Set<Data> keys, boolean replaceExistingValues) {
        super(name);
        this.keys = keys;
        this.replaceExistingValues = replaceExistingValues;
    }

    @Override
    protected void runInternal() {
        IPartitionService partitionService = this.getNodeEngine().getPartitionService();
        HashSet<Data> filteredKeys = new HashSet<Data>();
        if (this.keys != null) {
            for (Data k : this.keys) {
                if (partitionService.getPartitionId(k) != this.getPartitionId()) continue;
                filteredKeys.add(k);
            }
        }
        if (filteredKeys.isEmpty()) {
            return;
        }
        try {
            Set<Data> keysLoaded = this.recordStore.loadAll(filteredKeys, this.replaceExistingValues);
            boolean bl = this.shouldBackup = !keysLoaded.isEmpty();
            if (this.shouldBackup) {
                this.cacheBackupRecordStore = new CacheBackupRecordStore();
                for (Data key : keysLoaded) {
                    HiDensityCacheRecord record = (HiDensityCacheRecord)this.recordStore.getRecord(key);
                    if (record == null) continue;
                    this.cacheBackupRecordStore.addBackupRecord(key, (Data)record.getValue(), record.getCreationTime());
                }
            }
        }
        catch (CacheException e) {
            this.response = new CacheClearResponse((Object)e);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutAllBackupOperation(this.name, this.cacheBackupRecordStore, null);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.replaceExistingValues);
        if (this.keys == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                IOUtil.writeData(out, key);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.replaceExistingValues = in.readBoolean();
        int size = in.readInt();
        this.keys = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data key = HiDensityCacheOperation.readHeapOperationData(in);
            this.keys.add(key);
        }
    }

    @Override
    public int getClassId() {
        return 16;
    }
}

