/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheOperation;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.cache.expiry.ExpiryPolicy;

public class CacheGetAllOperation
extends HiDensityCacheOperation
implements ReadonlyOperation {
    private Set<Data> keys = new HashSet<Data>();
    private ExpiryPolicy expiryPolicy;

    public CacheGetAllOperation() {
    }

    public CacheGetAllOperation(String name, Set<Data> keys, ExpiryPolicy expiryPolicy) {
        super(name);
        this.keys = keys;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    protected void runInternal() {
        HashSet<Data> partitionKeySet = new HashSet<Data>();
        IPartitionService partitionService = this.getNodeEngine().getPartitionService();
        for (Data key : this.keys) {
            if (this.getPartitionId() != partitionService.getPartitionId(key)) continue;
            partitionKeySet.add(key);
        }
        this.response = this.recordStore.getAll(partitionKeySet, this.expiryPolicy);
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        this.dispose();
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        for (Data key : this.keys) {
            serializationService.disposeData(key);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.expiryPolicy);
        if (this.keys == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                IOUtil.writeData(out, key);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Data key = HiDensityCacheOperation.readNativeMemoryOperationData(in);
            this.keys.add(key);
        }
    }

    @Override
    public int getClassId() {
        return 14;
    }
}

