/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.BackupAwareKeyBasedHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CachePutBackupOperation;
import com.hazelcast.cache.impl.hidensity.operation.CacheRemoveBackupOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import javax.cache.processor.EntryProcessor;

public class CacheEntryProcessorOperation
extends BackupAwareKeyBasedHiDensityCacheOperation
implements MutableOperation,
MutatingOperation {
    private EntryProcessor entryProcessor;
    private Object[] arguments;
    private transient Data backupData;
    private transient long backupRecordCreationTime = -1L;

    public CacheEntryProcessorOperation() {
    }

    public CacheEntryProcessorOperation(String name, Data key, int completionId, EntryProcessor entryProcessor, Object ... arguments) {
        super(name, key, completionId);
        this.entryProcessor = entryProcessor;
        this.arguments = arguments;
    }

    @Override
    protected void runInternal() {
        this.response = this.recordStore.invoke(this.key, this.entryProcessor, this.arguments, this.completionId);
        CacheRecord record = this.recordStore.getRecord(this.key);
        if (record != null) {
            Object recordVal = record.getValue();
            if (recordVal instanceof Data) {
                Data dataVal = (Data)recordVal;
                this.backupData = dataVal instanceof NativeMemoryData ? this.serializationService.convertData(dataVal, DataType.HEAP) : dataVal;
            }
            this.backupRecordCreationTime = record.getCreationTime();
        }
    }

    @Override
    public void afterRun() throws Exception {
        if (this.recordStore.isWanReplicationEnabled()) {
            if (this.backupData != null) {
                this.publishWanUpdate(this.key, this.recordStore.getRecord(this.key));
            } else {
                this.publishWanRemove(this.key);
            }
        }
        super.afterRun();
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        if (!this.runCompleted) {
            serializationService.disposeData(this.key);
        }
    }

    @Override
    public Operation getBackupOperation() {
        if (this.backupData != null) {
            return new CachePutBackupOperation(this.name, this.key, this.backupData, null, this.backupRecordCreationTime);
        }
        return new CacheRemoveBackupOperation(this.name, this.key);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
        out.writeBoolean(this.arguments != null);
        if (this.arguments != null) {
            out.writeInt(this.arguments.length);
            for (Object arg : this.arguments) {
                out.writeObject(arg);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
        boolean hasArguments = in.readBoolean();
        if (hasArguments) {
            int size = in.readInt();
            this.arguments = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.arguments[i] = in.readObject();
            }
        }
    }

    @Override
    public int getClassId() {
        return 18;
    }
}

