/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.maxsize;

import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;

public class HiDensityUsedNativeMemoryPercentageEvictionChecker
implements EvictionChecker {
    private final HiDensityStorageInfo storageInfo;
    private final long maxUsedMemorySize;

    public HiDensityUsedNativeMemoryPercentageEvictionChecker(HiDensityStorageInfo storageInfo, int maxSizePercentage, long maxNativeMemory) {
        if (maxSizePercentage < 0 || maxSizePercentage > 100) {
            throw new IllegalArgumentException("\"maxSize\" can only be 0-100 for " + (Object)((Object)MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE) + " max-size policy !");
        }
        double maxSizeRatio = (double)maxSizePercentage / 100.0;
        this.storageInfo = storageInfo;
        this.maxUsedMemorySize = (long)((double)maxNativeMemory * maxSizeRatio);
    }

    @Override
    public boolean isEvictionRequired() {
        return this.storageInfo.getUsedMemory() >= this.maxUsedMemorySize;
    }
}

