/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.EnterpriseCacheService;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.wan.impl.merkletree.ArrayMerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class EnterpriseCachePartitionSegment
extends CachePartitionSegment {
    private final ConcurrentMap<String, MerkleTree> merkleTrees;
    private final ContextMutexFactory merkleTreesMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, MerkleTree> merkleTreeConstructor = mapName -> new ArrayMerkleTree(this.getMerkleTreeConfig((String)mapName).getDepth());

    public EnterpriseCachePartitionSegment(EnterpriseCacheService cacheService, int partitionId) {
        super(cacheService, partitionId);
        long merkleTreeCount = cacheService.configs.keySet().stream().filter(cacheName -> cacheService.shouldEnableMerkleTree((String)cacheName, false)).count();
        this.merkleTrees = MapUtil.createConcurrentHashMap((int)Math.max(merkleTreeCount, 1L));
    }

    @Nullable
    public MerkleTree getOrCreateMerkleTree(String cacheName, MerkleTreeConfig merkleTreeConfig) {
        if (merkleTreeConfig == null || !this.shouldEnableMerkleTree(cacheName, true)) {
            return null;
        }
        return ConcurrencyUtil.getOrPutSynchronized(this.merkleTrees, cacheName, this.merkleTreesMutexFactory, this.merkleTreeConstructor);
    }

    @Nullable
    public MerkleTree getMerkleTree(String cacheName) {
        MerkleTreeConfig config = this.getMerkleTreeConfig(cacheName);
        if (config == null || !this.shouldEnableMerkleTree(cacheName, false)) {
            return null;
        }
        return (MerkleTree)this.merkleTrees.get(cacheName);
    }

    @Nullable
    private MerkleTreeConfig getMerkleTreeConfig(String cacheName) {
        CacheConfig cacheConfig = this.cacheService.getCacheConfig(cacheName);
        if (cacheConfig == null) {
            return null;
        }
        return cacheConfig.getMerkleTreeConfig();
    }

    private boolean shouldEnableMerkleTree(String cacheName, boolean log) {
        return ((EnterpriseCacheService)this.cacheService).shouldEnableMerkleTree(cacheName, log);
    }
}

