/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.loginimpl;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.security.ClusterLoginModule;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class SimplePropertiesLoginModule
extends ClusterLoginModule
implements LoginModule {
    public static final String OPTION_PREFIX_PASSWORD = "password.";
    public static final String OPTION_PREFIX_ROLES = "roles.";
    public static final String OPTION_ROLE_SEPARATOR = "roleSeparator";
    public static final String DEFAULT_ROLE_SEPARATOR = ",";
    private String name;

    @Override
    public boolean onLogin() throws LoginException {
        NameCallback ncb = new NameCallback("Name");
        PasswordCallback pcb = new PasswordCallback("Password", false);
        try {
            this.callbackHandler.handle(new Callback[]{ncb, pcb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            this.logger.warning("Retrieving the password failed.", e);
            throw new LoginException("Unable to retrieve the password");
        }
        this.name = ncb.getName();
        char[] pass = pcb.getPassword();
        if (StringUtil.isNullOrEmpty(this.name) || pass == null || pass.length == 0) {
            throw new FailedLoginException("Empty usernames and/or passwords are not supported");
        }
        String actualPassword = new String(pass);
        String expectedPassword = this.getStringOption(OPTION_PREFIX_PASSWORD + this.name, null);
        if (!actualPassword.equals(expectedPassword)) {
            throw new FailedLoginException("Username/password provided don't match the expected values.");
        }
        String rs = this.getStringOption(OPTION_ROLE_SEPARATOR, DEFAULT_ROLE_SEPARATOR);
        String roles = this.getStringOption(OPTION_PREFIX_ROLES + this.name, "");
        if (!StringUtil.isNullOrEmpty(roles)) {
            Arrays.stream(roles.split(rs)).filter(r -> !r.isEmpty()).forEach(r -> this.addRole((String)r));
        }
        return true;
    }

    @Override
    protected String getName() {
        return this.name;
    }
}

