/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.LoginModuleConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public final class LoginConfigurationDelegate
extends Configuration {
    private final LoginModuleConfig[] loginModuleConfigs;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public LoginConfigurationDelegate(LoginModuleConfig[] loginModuleConfigs) {
        this.loginModuleConfigs = loginModuleConfigs;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] entries = new AppConfigurationEntry[this.loginModuleConfigs.length];
        for (int i = 0; i < this.loginModuleConfigs.length; ++i) {
            LoginModuleConfig module = this.loginModuleConfigs[i];
            AppConfigurationEntry.LoginModuleControlFlag flag = this.getFlag(module);
            HashMap<Object, Object> options = new HashMap<Object, Object>(module.getProperties());
            entries[i] = new AppConfigurationEntry(module.getClassName(), flag, options);
        }
        return entries;
    }

    private AppConfigurationEntry.LoginModuleControlFlag getFlag(LoginModuleConfig module) {
        switch (module.getUsage()) {
            case REQUIRED: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            }
            case OPTIONAL: {
                return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
            case REQUISITE: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
            case SUFFICIENT: {
                return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            }
        }
        return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return "LoginConfigurationDelegate [loginModuleConfigs=" + Arrays.toString(this.loginModuleConfigs) + "]";
    }
}

