/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.security.impl.WeakSecretError;
import com.hazelcast.security.impl.weaksecretrules.MinLengthRule;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public final class WeakSecretException
extends HazelcastException {
    public static final boolean ENFORCED = Boolean.parseBoolean(System.getProperty("hazelcast.security.secret.strength.policy.enforced", "false"));
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final Map<WeakSecretError, String> WEAKNESS_DESCRIPTIONS = new HashMap<WeakSecretError, String>();
    private final EnumSet<WeakSecretError> weaknesses;

    private WeakSecretException(EnumSet<WeakSecretError> weaknesses, String details) {
        super(details);
        this.weaknesses = weaknesses;
    }

    public WeakSecretException(String message) {
        super(message);
        this.weaknesses = null;
    }

    public EnumSet<WeakSecretError> getWeaknesses() {
        return this.weaknesses;
    }

    public static WeakSecretException of(String label, EnumSet<WeakSecretError> weaknesses) {
        return new WeakSecretException(weaknesses, WeakSecretException.formatMessage(label, weaknesses));
    }

    public static String formatMessage(String label, EnumSet<WeakSecretError> weaknesses) {
        StringBuilder details = new StringBuilder();
        details.append(label).append(" does not meet the current policy and complexity requirements. ");
        details.append(LINE_SEP);
        int count = 0;
        for (WeakSecretError weakness : weaknesses) {
            details.append(WEAKNESS_DESCRIPTIONS.get((Object)weakness));
            if (++count >= weaknesses.size()) continue;
            details.append(LINE_SEP);
        }
        return details.toString();
    }

    static {
        WEAKNESS_DESCRIPTIONS.put(WeakSecretError.DEFAULT, "*Must not be set to the default.");
        WEAKNESS_DESCRIPTIONS.put(WeakSecretError.MIN_LEN, "*Must contain " + MinLengthRule.MIN_ALLOWED_SECRET_LENGTH + " or more characters.");
        WEAKNESS_DESCRIPTIONS.put(WeakSecretError.DICT_WORD, "*Must not be a dictionary word.");
        WEAKNESS_DESCRIPTIONS.put(WeakSecretError.NO_ALPHA, "*Must have at least 1 alphabetic character.");
        WEAKNESS_DESCRIPTIONS.put(WeakSecretError.NO_MIXED_CASE, "*Must have at least 1 lower and 1 upper case characters.");
        WEAKNESS_DESCRIPTIONS.put(WeakSecretError.NO_NUMERAL, "*Must contain at least 1 number.");
        WEAKNESS_DESCRIPTIONS.put(WeakSecretError.NO_SPECIAL_CHARS, "*Must contain at least 1 special character.");
    }
}

