/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.bplustree.TStoreBTreeAllocator;
import com.hazelcast.internal.bplustree.TStoreBTreeCompactor;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.PoolingMemoryManager;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.monitor.impl.HDGlobalPerIndexStats;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.TieredStoreUser;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.query.impl.HDBaseConcurrentIndexStore;
import com.hazelcast.query.impl.HDIndexImpl;
import com.hazelcast.query.impl.HDOrderedConcurrentIndexStore;
import com.hazelcast.query.impl.HDUnorderedConcurrentIndexStore;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.TStoreBTreeAllocatorDependencies;
import com.hazelcast.query.impl.getters.Extractors;

public class TSGlobalIndexImpl
extends IndexImpl {
    private HybridLog globalIndexHybridLog;

    public TSGlobalIndexImpl(Node node, IndexConfig config, InternalSerializationService ss, Extractors extractors, PerIndexStats stats, int partitionCount, String mapName) {
        super(node, config, ss, extractors, IndexCopyBehavior.NEVER, stats, partitionCount, mapName);
    }

    @Override
    protected IndexStore createIndexStore(Node node, IndexConfig config, PerIndexStats stats, String mapName) {
        EnterpriseSerializationService ess = (EnterpriseSerializationService)this.ss;
        HazelcastMemoryManager memoryManager = ess.getMemoryManager();
        if (!(memoryManager instanceof PoolingMemoryManager)) {
            throw new IllegalArgumentException("HD global indices require Pooling Memory Manager");
        }
        PoolingMemoryManager poolingMemoryManager = (PoolingMemoryManager)memoryManager;
        MemoryAllocator wrappedKeyAllocator = stats.wrapMemoryAllocator(poolingMemoryManager.getGlobalMemoryManager());
        int nodeSize = (int)config.getBTreeIndexConfig().getPageSize().bytes();
        LibMalloc libMalloc = poolingMemoryManager.getLibMalloc();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)node.getNodeExtension();
        TieredStoreService tieredStoreService = nodeExtension.getTieredStoreService();
        Epoch epoch = tieredStoreService.epoch();
        InternalPartitionService partitionService = node.getPartitionService();
        MapService mapService = (MapService)node.getNodeEngine().getService("hz:impl:mapService");
        EnterpriseMapServiceContext mapServiceContext = (EnterpriseMapServiceContext)mapService.getMapServiceContext();
        String deviceName = node.getConfig().findMapConfig(mapName).getTieredStoreConfig().getDiskTierConfig().getDeviceName();
        CompactionManager compactionManager = tieredStoreService.compactionManager(deviceName);
        this.globalIndexHybridLog = tieredStoreService.createHybridLogForGlobalIndex(TieredStoreUser.BTREE, mapName, config);
        String id = ((HybridLogImpl)this.globalIndexHybridLog).getId();
        TStoreBTreeAllocator indexAllocator = new TStoreBTreeAllocator(libMalloc, (PooledNativeMemoryStats)poolingMemoryManager.getMemoryStats(), nodeSize, epoch, this.globalIndexHybridLog, new TStoreBTreeAllocatorDependencies(partitionService, mapServiceContext, mapName, compactionManager, new TStoreUserId(TieredStoreUser.BTREE, id)));
        TStoreAllocatorWithStats wrappedIndexAllocator = new TStoreAllocatorWithStats(indexAllocator, (HDGlobalPerIndexStats)stats);
        HDIndexImpl.OnHeapEntryFactory entryFactory = new HDIndexImpl.OnHeapEntryFactory(ess, this.extractors);
        switch (config.getType()) {
            case SORTED: {
                return new HDOrderedConcurrentIndexStore(this.copyBehavior, ess, wrappedKeyAllocator, wrappedIndexAllocator, entryFactory, nodeSize, true);
            }
            case HASH: {
                return new HDUnorderedConcurrentIndexStore(this.copyBehavior, ess, wrappedKeyAllocator, wrappedIndexAllocator, entryFactory, nodeSize, true);
            }
            case BITMAP: {
                throw new IllegalArgumentException("Bitmap indexes are not supported by NATIVE storage");
            }
        }
        throw new IllegalArgumentException("unexpected index type: " + (Object)((Object)config.getType()));
    }

    @Override
    public void destroy() {
        this.indexStore.destroy();
        super.destroy();
    }

    public HybridLog getGlobalIndexHybridLog() {
        return this.globalIndexHybridLog;
    }

    @Override
    public String toString() {
        return "TSGlobalIndexImpl{} " + super.toString();
    }

    public int getNodeSize() {
        return ((HDBaseConcurrentIndexStore)this.indexStore).getNodeSize();
    }

    private static class TStoreAllocatorWithStats
    implements TStoreAllocator {
        private final TStoreBTreeAllocator delegateAllocator;
        private final HDGlobalPerIndexStats delegateStats;

        TStoreAllocatorWithStats(TStoreBTreeAllocator tstoreAllocator, HDGlobalPerIndexStats stats) {
            this.delegateAllocator = tstoreAllocator;
            this.delegateStats = stats;
        }

        @Override
        public int getKeyPartition(Data key) {
            return this.delegateAllocator.getKeyPartition(key);
        }

        @Override
        public void allocateLogical(long stableAddress) {
            this.delegateAllocator.allocateLogical(stableAddress);
            this.delegateStats.updateMemoryCost(this.delegateAllocator.getNodeSize());
        }

        @Override
        public boolean isAllocated(long stableAddress) {
            return this.delegateAllocator.isAllocated(stableAddress);
        }

        @Override
        public long translateToLogical(long stableAddress) {
            return this.delegateAllocator.translateToLogical(stableAddress);
        }

        @Override
        public long translateToPhysical(long stableAddress) {
            return this.delegateAllocator.translateToPhysical(stableAddress);
        }

        @Override
        public long getLockAddress(long stableAddress) {
            return this.delegateAllocator.getLockAddress(stableAddress);
        }

        @Override
        public long tryLockRecord(int partition, long keyHash) {
            return this.delegateAllocator.tryLockRecord(partition, keyHash);
        }

        @Override
        public void waitUntilRecordUnlocked(int partition, long keyHash, long cookie) {
            this.delegateAllocator.waitUntilRecordUnlocked(partition, keyHash, cookie);
        }

        @Override
        public void unlockRecord(int partition, long keyHash, long cookie) {
            this.delegateAllocator.unlockRecord(partition, keyHash, cookie);
        }

        @Override
        public Data getRecordValue(int partition, Data key) {
            return this.delegateAllocator.getRecordValue(partition, key);
        }

        @Override
        public void yield(int partition) {
            this.delegateAllocator.yield(partition);
        }

        @Override
        public void pinAndReplaceLastUnpinned(long stableAddress, LockingContext lockingContext) {
            this.delegateAllocator.pinAndReplaceLastUnpinned(stableAddress, lockingContext);
        }

        @Override
        public void unpinIfNotLastUnpinned(long stableAddress, LockingContext lockingContext) {
            this.delegateAllocator.unpinIfNotLastUnpinned(stableAddress, lockingContext);
        }

        @Override
        public void unpin(long stableAddress) {
            this.delegateAllocator.unpin(stableAddress);
        }

        @Override
        public void ensureReadable(long stableAddress) {
            this.delegateAllocator.ensureReadable(stableAddress);
        }

        @Override
        public void ensureWritable(long stableAddress) {
            this.delegateAllocator.ensureWritable(stableAddress);
        }

        @Override
        public void upgradeToWritable(long stableAddress, LockingContext lockingContext) {
            this.delegateAllocator.upgradeToWritable(stableAddress, lockingContext);
        }

        @Override
        public void registerEpoch() {
            this.delegateAllocator.registerEpoch();
        }

        @Override
        public void unregisterEpoch() {
            this.delegateAllocator.unregisterEpoch();
        }

        @Override
        public void pauseEpoch() {
            this.delegateAllocator.pauseEpoch();
        }

        @Override
        public void resumeEpoch() {
            this.delegateAllocator.resumeEpoch();
        }

        @Override
        public void registerState(int partitionId) {
            this.delegateAllocator.registerState(partitionId);
        }

        @Override
        public void unregisterState(int partitionId) {
            this.delegateAllocator.unregisterState(partitionId);
        }

        @Override
        public PartitionIdSet newPartitionIdSet() {
            return this.delegateAllocator.newPartitionIdSet();
        }

        @Override
        public void registerCompactor(TStoreBTreeCompactor.Dependencies compactorDeps) {
            this.delegateAllocator.registerCompactor(compactorDeps);
        }

        @Override
        public long allocate(long size) {
            long address = this.delegateAllocator.allocate(size);
            this.delegateStats.updateMemoryCost(size);
            return address;
        }

        @Override
        public long reallocate(long address, long currentSize, long newSize) {
            long newAddress = this.delegateAllocator.reallocate(address, currentSize, newSize);
            this.delegateStats.updateMemoryCost(newSize - currentSize);
            return newAddress;
        }

        @Override
        public void free(long address, long size) {
            this.delegateAllocator.free(address, size);
            this.delegateStats.updateMemoryCost(-size);
        }

        @Override
        public void dispose() {
            this.delegateAllocator.dispose();
            this.delegateStats.resetMemoryCost();
        }
    }
}

