/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.BaseSingleValueIndexStore;
import com.hazelcast.query.impl.Comparables;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.CompositeValue;
import com.hazelcast.query.impl.HDIndexHashMap;
import com.hazelcast.query.impl.HDIndexNestedHashMap;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.Numbers;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class HDUnorderedIndexStore
extends BaseSingleValueIndexStore {
    private final EnterpriseSerializationService ess;
    private final HDIndexHashMap<QueryableEntry> recordsWithNullValue;
    private final HDIndexNestedHashMap<QueryableEntry> records;

    HDUnorderedIndexStore(EnterpriseSerializationService ess, MemoryAllocator malloc, MapEntryFactory<QueryableEntry> entryFactory) {
        super(IndexCopyBehavior.NEVER, false);
        ThreadUtil.assertRunningOnPartitionThread();
        this.ess = ess;
        this.recordsWithNullValue = new HDIndexHashMap<QueryableEntry>(ess, malloc, entryFactory);
        try {
            this.records = new HDIndexNestedHashMap<QueryableEntry>(ess, malloc, entryFactory);
        }
        catch (NativeOutOfMemoryError e) {
            this.recordsWithNullValue.dispose();
            throw e;
        }
    }

    @Override
    Object insertInternal(Comparable attributeValue, QueryableEntry entry) {
        ThreadUtil.assertRunningOnPartitionThread();
        NativeMemoryData key = (NativeMemoryData)entry.getKeyData();
        NativeMemoryData value = (NativeMemoryData)entry.getValueData();
        if (attributeValue == AbstractIndex.NULL) {
            return this.recordsWithNullValue.put(key, value);
        }
        return this.records.put(attributeValue, key, value);
    }

    @Override
    Object removeInternal(Comparable attributeValue, Data key) {
        ThreadUtil.assertRunningOnPartitionThread();
        if (attributeValue == AbstractIndex.NULL) {
            return this.recordsWithNullValue.remove(key);
        }
        return this.records.remove(attributeValue, (NativeMemoryData)key);
    }

    @Override
    public void destroy() {
        ThreadUtil.assertRunningOnPartitionThread();
        try {
            this.clear();
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public boolean isEvaluateOnly() {
        return false;
    }

    @Override
    public boolean canEvaluate(Class<? extends Predicate> predicateClass) {
        return false;
    }

    @Override
    public Set<QueryableEntry> evaluate(Predicate predicate, TypeConverter converter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparable canonicalizeQueryArgumentScalar(Comparable value) {
        return this.canonicalizeScalarForStorage(value);
    }

    @Override
    public Comparable canonicalizeScalarForStorage(Comparable value) {
        return HDUnorderedIndexStore.canonicalizeScalarForStorage0(value);
    }

    @Override
    public void clear() {
        ThreadUtil.assertRunningOnPartitionThread();
        this.recordsWithNullValue.clear();
        this.records.clear();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(boolean descending) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparison comparison, Comparable value, boolean descending) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<QueryableEntry> getSqlRecordIterator(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(boolean descending) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparison comparison, Comparable value, boolean descending) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        return this.getRecordsInternal(HDUnorderedIndexStore.canonicalize(value));
    }

    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        ThreadUtil.assertRunningOnPartitionThread();
        HashSet<QueryableEntry> results = new HashSet<QueryableEntry>();
        for (Comparable value : values) {
            results.addAll(this.getRecordsInternal(value));
        }
        return results;
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparison comparison, Comparable value) {
        ThreadUtil.assertRunningOnPartitionThread();
        HashSet<QueryableEntry> results = new HashSet<QueryableEntry>();
        for (Data data : this.records.keySet()) {
            boolean valid;
            Comparable indexedValue = (Comparable)this.ess.toObject(data);
            int result = Comparables.compare(value, indexedValue);
            switch (comparison) {
                case LESS: {
                    valid = result > 0;
                    break;
                }
                case LESS_OR_EQUAL: {
                    valid = result >= 0;
                    break;
                }
                case GREATER: {
                    valid = result < 0;
                    break;
                }
                case GREATER_OR_EQUAL: {
                    valid = result <= 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized comparison: " + (Object)((Object)comparison));
                }
            }
            if (!valid) continue;
            results.addAll(this.records.get(indexedValue));
        }
        return results;
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive) {
        ThreadUtil.assertRunningOnPartitionThread();
        if (Comparables.compare(from, to) == 0) {
            if (!fromInclusive || !toInclusive) {
                return Collections.emptySet();
            }
            return this.records.get(HDUnorderedIndexStore.canonicalize(from));
        }
        HashSet<QueryableEntry> results = new HashSet<QueryableEntry>();
        int fromBound = fromInclusive ? 0 : 1;
        int toBound = toInclusive ? 0 : -1;
        for (Data data : this.records.keySet()) {
            Comparable value = (Comparable)this.ess.toObject(data);
            if (Comparables.compare(value, from) < fromBound || Comparables.compare(value, to) > toBound) continue;
            results.addAll(this.records.get(HDUnorderedIndexStore.canonicalize(value)));
        }
        return results;
    }

    private Set<QueryableEntry> getRecordsInternal(Comparable canonicalValue) {
        ThreadUtil.assertRunningOnPartitionThread();
        if (canonicalValue == AbstractIndex.NULL) {
            return this.recordsWithNullValue.entrySet();
        }
        return this.records.get(canonicalValue);
    }

    private void dispose() {
        ThreadUtil.assertRunningOnPartitionThread();
        this.recordsWithNullValue.dispose();
        this.records.dispose();
    }

    static Comparable canonicalize(Comparable value) {
        if (value instanceof CompositeValue) {
            Comparable[] components = ((CompositeValue)value).getComponents();
            for (int i = 0; i < components.length; ++i) {
                components[i] = HDUnorderedIndexStore.canonicalizeScalarForStorage0(components[i]);
            }
            return value;
        }
        return HDUnorderedIndexStore.canonicalizeScalarForStorage0(value);
    }

    static Comparable canonicalizeLongRepresentable(long value) {
        if (value == (long)((short)value)) {
            return Short.valueOf((short)value);
        }
        return Long.valueOf(value);
    }

    static Comparable canonicalizeScalarForStorage0(Comparable value) {
        if (!(value instanceof Number)) {
            return value;
        }
        Class<?> clazz = value.getClass();
        Number number = (Number)((Object)value);
        if (Numbers.isDoubleRepresentable(clazz)) {
            long longValue;
            double doubleValue = number.doubleValue();
            if (Numbers.equalDoubles(doubleValue, longValue = number.longValue())) {
                return HDUnorderedIndexStore.canonicalizeLongRepresentable(longValue);
            }
            if (clazz == Float.class) {
                return Double.valueOf(doubleValue);
            }
        } else if (Numbers.isLongRepresentable(clazz)) {
            return HDUnorderedIndexStore.canonicalizeLongRepresentable(number.longValue());
        }
        return value;
    }
}

