/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema.loader;

import com.hazelcast.org.everit.json.schema.JSONPointerException;
import com.hazelcast.org.everit.json.schema.SchemaException;
import com.hazelcast.org.everit.json.schema.SchemaLocation;
import com.hazelcast.org.everit.json.schema.loader.JsonArray;
import com.hazelcast.org.everit.json.schema.loader.JsonObject;
import com.hazelcast.org.everit.json.schema.loader.JsonValue;
import com.hazelcast.org.everit.json.schema.loader.LoadingState;
import com.hazelcast.org.everit.json.schema.loader.OrgJsonUtil;
import com.hazelcast.org.everit.json.schema.loader.ReferenceLookup;
import com.hazelcast.org.everit.json.schema.loader.SchemaClient;
import com.hazelcast.org.everit.json.schema.loader.Uri;
import com.hazelcast.org.json.JSONException;
import com.hazelcast.org.json.JSONObject;
import com.hazelcast.org.json.JSONTokener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Supplier;

class JsonPointerEvaluator {
    private final Supplier<JsonObject> documentProvider;
    private final String fragment;

    private static JsonObject executeWith(SchemaClient client, String url) {
        String resp = null;
        BufferedReader buffReader = null;
        InputStreamReader reader = null;
        try {
            String line;
            InputStream responseStream = client.get(url);
            reader = new InputStreamReader(responseStream, Charset.defaultCharset());
            buffReader = new BufferedReader(reader);
            StringBuilder strBuilder = new StringBuilder();
            while ((line = buffReader.readLine()) != null) {
                strBuilder.append(line);
            }
            resp = strBuilder.toString();
            JsonObject jsonObject = new JsonObject(OrgJsonUtil.toMap(new JSONObject(new JSONTokener(resp))));
            return jsonObject;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (JSONException e) {
            throw new SchemaException(url, e);
        }
        finally {
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static final JsonPointerEvaluator forDocument(JsonObject document, String fragment) {
        return new JsonPointerEvaluator(() -> document, fragment);
    }

    private static JsonObject configureBasedOnState(JsonObject obj, LoadingState callingState, String id) {
        URI documentURI = JsonPointerEvaluator.validateURI(callingState, id).asJavaURI();
        obj.ls = callingState.createCopyForNewSchemaJson(documentURI, obj, new SchemaLocation(documentURI, Collections.emptyList()));
        return obj;
    }

    static final JsonPointerEvaluator forURL(SchemaClient schemaClient, String url, LoadingState callingState) {
        Uri uri = JsonPointerEvaluator.validateURI(callingState, url);
        return new JsonPointerEvaluator(() -> JsonPointerEvaluator.configureBasedOnState(JsonPointerEvaluator.executeWith(schemaClient, uri.toBeQueried.toString()), callingState, uri.toBeQueried.toString()), uri.fragment);
    }

    private static Uri validateURI(LoadingState callingState, String toBeQueried) {
        try {
            return Uri.parse(toBeQueried);
        }
        catch (URISyntaxException e) {
            throw callingState.createSchemaException(e);
        }
    }

    JsonPointerEvaluator(Supplier<JsonObject> documentProvider, String fragment) {
        this.documentProvider = documentProvider;
        this.fragment = fragment;
    }

    public QueryResult query() {
        JsonObject document = this.documentProvider.get();
        if (this.fragment.isEmpty()) {
            return new QueryResult(document, document);
        }
        JsonObject foundById = ReferenceLookup.lookupObjById(document, this.fragment);
        if (foundById != null) {
            return new QueryResult(document, foundById);
        }
        String[] path = this.fragment.split("/");
        if (path[0] == null || !path[0].startsWith("#")) {
            throw new IllegalArgumentException("JSON pointers must start with a '#'");
        }
        try {
            LinkedList<String> tokens = new LinkedList<String>(Arrays.asList(path));
            tokens.poll();
            JsonValue result = tokens.isEmpty() ? document : this.queryFrom(document, tokens);
            return new QueryResult(document, result);
        }
        catch (JSONPointerException e) {
            throw new SchemaException(e.getMessage());
        }
    }

    private String unescape(String token) {
        try {
            return URLDecoder.decode(token, "utf-8").replace("~1", "/").replace("~0", "~").replace("\\\"", "\"").replace("\\\\", "\\");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonValue queryFrom(JsonValue document, LinkedList<String> tokens) {
        String key = this.unescape(tokens.poll());
        JsonValue next = document.canBeMappedTo(JsonObject.class, obj -> obj.childFor(key)).orMappedTo(JsonArray.class, arr -> arr.at(Integer.parseInt(key))).requireAny();
        if (tokens.isEmpty()) {
            return next;
        }
        return this.queryFrom(next, tokens);
    }

    static class QueryResult {
        private final JsonObject containingDocument;
        private final JsonValue queryResult;

        QueryResult(JsonObject containingDocument, JsonValue queryResult) {
            this.containingDocument = Objects.requireNonNull(containingDocument, "containingDocument cannot be null");
            this.queryResult = Objects.requireNonNull(queryResult, "queryResult cannot be null");
        }

        public JsonObject getContainingDocument() {
            return this.containingDocument;
        }

        public JsonValue getQueryResult() {
            return this.queryResult;
        }
    }
}

