/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.map.impl.wan.WanMapEntryView;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanEventType;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanEnterpriseMapSyncEvent
extends WanEnterpriseMapEvent<EntryView<Object, Object>> {
    private transient UUID uuid;
    private WanMapEntryView<Object, Object> entryView;
    private transient int partitionId;

    public WanEnterpriseMapSyncEvent(UUID uuid, String mapName, WanMapEntryView<Object, Object> entryView, int partitionId) {
        super(mapName, 0);
        this.uuid = uuid;
        this.entryView = entryView;
        this.partitionId = partitionId;
    }

    public WanEnterpriseMapSyncEvent() {
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public WanMapEntryView<Object, Object> getEntryView() {
        return this.entryView;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.entryView);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.entryView = (WanMapEntryView)in.readObject();
    }

    @Override
    @Nonnull
    public Data getKey() {
        return this.entryView.getDataKey();
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void incrementEventCount(@Nonnull WanEventCounters counters) {
        counters.incrementSync(this.getMapName());
    }

    @Override
    @Nonnull
    public WanEventType getEventType() {
        return WanEventType.SYNC;
    }

    @Override
    @Nullable
    public EntryView<Object, Object> getEventObject() {
        return this.entryView;
    }
}

