/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.hidensity.impl.AbstractHiDensityRecordAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.HDRecordWithStats;
import com.hazelcast.map.impl.record.HDSimpleRecordWithHotRestart;
import com.hazelcast.map.impl.record.HDSimpleRecordWithLFUEviction;
import com.hazelcast.map.impl.record.HDSimpleRecordWithLFUEvictionAndHotRestart;
import com.hazelcast.map.impl.record.HDSimpleRecordWithLRUEviction;
import com.hazelcast.map.impl.record.HDSimpleRecordWithLRUEvictionAndHotRestart;
import com.hazelcast.map.impl.record.HDSimpleRecordWithVersion;

public class HDMapRecordAccessor
extends AbstractHiDensityRecordAccessor<HDRecord> {
    private final MapContainer mapContainer;

    public HDMapRecordAccessor(EnterpriseSerializationService ss, MapContainer mapContainer) {
        super(ss, ss.getMemoryManager());
        this.mapContainer = mapContainer;
    }

    @Override
    protected HDRecord createRecord() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        boolean hasHotRestart = mapConfig.getHotRestartConfig().isEnabled();
        if (mapConfig.isPerEntryStatsEnabled()) {
            return new HDRecordWithStats(this);
        }
        if (!hasEviction && !hasHotRestart) {
            return new HDSimpleRecordWithVersion(this);
        }
        if (hasEviction && !hasHotRestart) {
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LRU) {
                return new HDSimpleRecordWithLRUEviction(this);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LFU) {
                return new HDSimpleRecordWithLFUEviction(this);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.RANDOM) {
                return new HDSimpleRecordWithVersion(this);
            }
            return new HDRecordWithStats(this);
        }
        if (!hasEviction && hasHotRestart) {
            return new HDSimpleRecordWithHotRestart(this);
        }
        if (hasEviction && hasHotRestart) {
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LRU) {
                return new HDSimpleRecordWithLRUEvictionAndHotRestart(this);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LFU) {
                return new HDSimpleRecordWithLFUEvictionAndHotRestart(this);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.RANDOM) {
                return new HDSimpleRecordWithHotRestart(this);
            }
            return new HDRecordWithStats(this);
        }
        throw new IllegalStateException("No HD record type found matching with the provided " + mapConfig);
    }

    @Override
    public boolean isEqual(long address1, long address2) {
        if (address1 == address2) {
            return true;
        }
        if (address1 == 0L || address2 == 0L) {
            return false;
        }
        long valueAddress1 = GlobalMemoryAccessorRegistry.AMEM.getLong(address1 + 0L);
        long valueAddress2 = GlobalMemoryAccessorRegistry.AMEM.getLong(address2 + 0L);
        return NativeMemoryDataUtil.equals(valueAddress1, valueAddress2);
    }
}

