/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.memory.MemoryBlockAccessor;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.map.impl.record.HDJsonMetadataRecord;

public class HDJsonMetadataRecordAccessor
implements MemoryBlockAccessor<HDJsonMetadataRecord> {
    private final EnterpriseSerializationService ess;

    public HDJsonMetadataRecordAccessor(EnterpriseSerializationService ess) {
        this.ess = ess;
    }

    public HDJsonMetadataRecord newRecord() {
        return new HDJsonMetadataRecord(this.ess);
    }

    @Override
    public boolean isEqual(long address, HDJsonMetadataRecord value) {
        return this.isEqual(address, value.address());
    }

    @Override
    public boolean isEqual(long address1, long address2) {
        if (address1 == address2) {
            return true;
        }
        if (address1 == 0L || address2 == 0L) {
            return false;
        }
        long keyAddress1 = GlobalMemoryAccessorRegistry.AMEM.getLong(address1 + 0L);
        long keyAddress2 = GlobalMemoryAccessorRegistry.AMEM.getLong(address2 + 0L);
        long valueAddress1 = GlobalMemoryAccessorRegistry.AMEM.getLong(address1 + 8L);
        long valueAddress2 = GlobalMemoryAccessorRegistry.AMEM.getLong(address2 + 8L);
        return NativeMemoryDataUtil.equals(keyAddress1, keyAddress2) && NativeMemoryDataUtil.equals(valueAddress1, valueAddress2);
    }

    @Override
    public HDJsonMetadataRecord read(long address) {
        if (address == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + address);
        }
        HDJsonMetadataRecord record = this.newRecord();
        record.reset(address);
        return record;
    }

    @Override
    public long dispose(HDJsonMetadataRecord record) {
        if (record.address() == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + record.address());
        }
        long size = 0L;
        size += this.disposeMetadataKeyValue(record);
        this.ess.getMemoryManager().free(record.address(), record.size());
        record.reset(0L);
        return size += this.getSize(record);
    }

    public long disposeMetadataKeyValue(HDJsonMetadataRecord record) {
        NativeMemoryData valueData;
        long size = 0L;
        NativeMemoryData keyData = record.getKey();
        if (keyData != null) {
            size += this.disposeData(keyData);
            record.setKeyAddress(0L);
        }
        if ((valueData = record.getValue()) != null) {
            size += this.disposeData(valueData);
            record.setValueAddress(0L);
        }
        return size;
    }

    public long disposeMetadataKeyValue(HDJsonMetadataRecord record, boolean isKey) {
        long size = 0L;
        if (isKey) {
            NativeMemoryData keyData = record.getKey();
            if (keyData != null) {
                size += this.disposeData(keyData);
                record.setKeyAddress(0L);
            }
        } else {
            NativeMemoryData valueData = record.getValue();
            if (valueData != null) {
                size += this.disposeData(valueData);
                record.setValueAddress(0L);
            }
        }
        return size;
    }

    public long disposeData(NativeMemoryData value) {
        if (value.address() == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + value.address());
        }
        long size = this.getSize(value);
        this.ess.disposeData(value, this.ess.getMemoryManager());
        return size;
    }

    @Override
    public long dispose(long address) {
        return this.dispose(this.read(address));
    }

    public long getSize(MemoryBlock memoryBlock) {
        if (memoryBlock == null || memoryBlock.address() == 0L) {
            return 0L;
        }
        long size = this.ess.getMemoryManager().getAllocatedSize(memoryBlock.address());
        if (size == -1L) {
            size = memoryBlock.size();
        }
        return size;
    }

    public long getSize(long address, long expectedSize) {
        if (address == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + address);
        }
        long size = this.ess.getMemoryManager().getAllocatedSize(address);
        if (size == -1L) {
            size = expectedSize;
        }
        return size;
    }
}

