/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.event;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.enterprise.wan.WanFilterEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.event.MapEventPublisherImpl;
import com.hazelcast.map.impl.wan.MapFilterProvider;
import com.hazelcast.map.impl.wan.WanEnterpriseMapAddOrUpdateEvent;
import com.hazelcast.map.impl.wan.WanEnterpriseMapRemoveEvent;
import com.hazelcast.map.impl.wan.WanMapEntryView;
import com.hazelcast.map.wan.MapWanEventFilter;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class EnterpriseMapEventPublisherImpl
extends MapEventPublisherImpl {
    public EnterpriseMapEventPublisherImpl(EnterpriseMapServiceContext mapServiceContext) {
        super(mapServiceContext);
    }

    @Override
    public void publishEvent(Address caller, String mapName, EntryEventType eventType, Data dataKey, Object oldValue, Object value, Object mergingValue) {
        Collection<EventRegistration> registrations = this.getRegistrations(mapName);
        if (CollectionUtil.isEmpty(registrations)) {
            return;
        }
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        InMemoryFormat inMemoryFormat = mapContainer.getMapConfig().getInMemoryFormat();
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            dataKey = this.toHeapData(dataKey);
            oldValue = this.toHeapData(oldValue);
            value = this.toHeapData(value);
            mergingValue = this.toHeapData(mergingValue);
        }
        super.publishEvent(caller, mapName, eventType, dataKey, oldValue, value, mergingValue);
    }

    private Data toHeapData(Object object) {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EnterpriseSerializationService serializationService = (EnterpriseSerializationService)nodeEngine.getSerializationService();
        return serializationService.toData(object, DataType.HEAP);
    }

    @Override
    public void publishWanUpdate(@Nonnull String mapName, @Nonnull WanMapEntryView<Object, Object> entryView, boolean hasLoadProvenance) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        SplitBrainMergePolicy wanMergePolicy = mapContainer.getWanMergePolicy();
        int totalBackupCount = mapContainer.getTotalBackupCount();
        WanEnterpriseMapAddOrUpdateEvent replicationEvent = new WanEnterpriseMapAddOrUpdateEvent(mapName, wanMergePolicy, entryView, totalBackupCount);
        if (!this.isEventFiltered(mapContainer, entryView, hasLoadProvenance ? WanFilterEventType.LOADED : WanFilterEventType.UPDATED)) {
            this.publishWanEvent(mapName, replicationEvent);
        }
    }

    @Override
    public void publishWanRemove(@Nonnull String mapName, @Nonnull Data key) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        int totalBackupCount = mapContainer.getTotalBackupCount();
        WanEnterpriseMapRemoveEvent event = new WanEnterpriseMapRemoveEvent(mapName, this.toHeapData(key), totalBackupCount, this.serializationService);
        WanMapEntryView<Object, Object> entryView = new WanMapEntryView<Object, Object>(key, null, this.serializationService);
        if (!this.isEventFiltered(mapContainer, entryView, WanFilterEventType.REMOVED)) {
            this.publishWanEvent(mapName, event);
        }
    }

    private boolean isEventFiltered(MapContainer mapContainer, WanMapEntryView<Object, Object> entryView, WanFilterEventType eventType) {
        MapConfig mapConfig = mapContainer.getMapConfig();
        WanReplicationRef wanReplicationRef = mapConfig.getWanReplicationRef();
        List<String> filters = EnterpriseMapEventPublisherImpl.getFiltersFrom(wanReplicationRef);
        if (filters.isEmpty()) {
            return eventType == WanFilterEventType.LOADED;
        }
        MapFilterProvider mapFilterProvider = this.getEnterpriseMapServiceContext().getMapFilterProvider();
        for (String filterName : filters) {
            MapWanEventFilter wanEventFilter = mapFilterProvider.getFilter(filterName);
            if (!wanEventFilter.filter(mapContainer.getName(), entryView, eventType)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getFiltersFrom(WanReplicationRef wanReplicationRef) {
        if (wanReplicationRef == null) {
            return Collections.emptyList();
        }
        List<String> filters = wanReplicationRef.getFilters();
        return CollectionUtil.isEmpty(filters) ? Collections.emptyList() : filters;
    }

    private EnterpriseMapServiceContext getEnterpriseMapServiceContext() {
        return (EnterpriseMapServiceContext)this.mapServiceContext;
    }
}

