/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.map.impl.EntryCostEstimator;
import com.hazelcast.map.impl.record.HDRecord;

public class NativeMapEntryCostEstimator
implements EntryCostEstimator<NativeMemoryData, MemoryBlock> {
    private static final int SLOT_COST_IN_BYTES = 16;
    private volatile long estimate;
    private final HiDensityRecordProcessor recordProcessor;

    public NativeMapEntryCostEstimator(HiDensityRecordProcessor recordProcessor) {
        this.recordProcessor = recordProcessor;
    }

    @Override
    public long getEstimate() {
        return this.estimate;
    }

    @Override
    public void adjustEstimateBy(long adjustment) {
        this.estimate += adjustment;
    }

    @Override
    public void reset() {
        this.estimate = 0L;
    }

    @Override
    public long calculateValueCost(MemoryBlock record) {
        if (record instanceof HDRecord) {
            return this.getSize(record) + this.getSize((MemoryBlock)((Object)((HDRecord)record).getValue()));
        }
        return this.getSize(record);
    }

    @Override
    public long calculateEntryCost(NativeMemoryData key, MemoryBlock record) {
        if (record instanceof HDRecord) {
            return this.getSize(record) + this.getSize((MemoryBlock)((Object)((HDRecord)record).getValue())) + this.getSize(key) + 16L;
        }
        return this.getSize(key) + this.getSize(record) + 16L;
    }

    private long getSize(MemoryBlock block) {
        return block != null && block.address() != 0L ? this.recordProcessor.getSize(block) : 0L;
    }
}

