/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.collection.IntHashSet;
import com.hazelcast.map.impl.NotifiableIterator;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class MerkleTreeDiffIterator<R>
implements Iterator<Map.Entry<Data, R>>,
NotifiableIterator {
    private static final int LEVEL_FULL_SYNC_REQUIRED = -1;
    private static final int LEVEL_NO_DIFF_DETECTED = -2;
    private final int merkleTreeLevelOfNodes;
    private final IntHashSet merkleTreeOrderValues;
    private final Iterator<Map.Entry<Data, ? extends R>> delegate;
    private volatile Map.Entry<Data, ? extends R> cachedEntry;

    public MerkleTreeDiffIterator(Iterator<Map.Entry<Data, ? extends R>> delegate, int[] merkleTreeDiff) {
        if (delegate instanceof MerkleTreeDiffIterator) {
            throw new HazelcastException("Merkle tree diff iterator probably shouldn't wrap another merkle tree diff iterator - potential bug?");
        }
        this.delegate = delegate;
        if (merkleTreeDiff != null && merkleTreeDiff.length > 0) {
            this.merkleTreeOrderValues = MerkleTreeUtil.setOfNodeOrders(merkleTreeDiff);
            this.merkleTreeLevelOfNodes = MerkleTreeUtil.getLevelOfNode(merkleTreeDiff[0]);
        } else {
            this.merkleTreeOrderValues = null;
            this.merkleTreeLevelOfNodes = merkleTreeDiff == null ? -1 : -2;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.merkleTreeLevelOfNodes == -2) {
            return false;
        }
        if (this.merkleTreeLevelOfNodes == -1) {
            return this.delegate.hasNext();
        }
        if (this.cachedEntry != null) {
            return true;
        }
        while (this.delegate.hasNext()) {
            this.cachedEntry = this.delegate.next();
            Data dataKey = this.cachedEntry.getKey();
            assert (dataKey != null);
            int keyHash = dataKey.hashCode();
            int currentKeyNodeOrder = MerkleTreeUtil.getLeafOrderForHash(keyHash, this.merkleTreeLevelOfNodes);
            if (!this.merkleTreeOrderValues.contains(currentKeyNodeOrder)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map.Entry<Data, R> next() {
        if (this.merkleTreeLevelOfNodes == -2) {
            throw new NoSuchElementException("No diff detected");
        }
        if (this.merkleTreeLevelOfNodes == -1) {
            return this.delegate.next();
        }
        if (this.cachedEntry != null) {
            Map.Entry<Data, ? extends R> tmp = this.cachedEntry;
            this.cachedEntry = null;
            return tmp;
        }
        while (this.delegate.hasNext()) {
            Map.Entry<Data, R> entry = this.delegate.next();
            Data dataKey = entry.getKey();
            int keyHash = dataKey.hashCode();
            int currentKeyNodeOrder = MerkleTreeUtil.getLeafOrderForHash(keyHash, this.merkleTreeLevelOfNodes);
            if (!this.merkleTreeOrderValues.contains(currentKeyNodeOrder)) continue;
            return entry;
        }
        throw new NoSuchElementException("Delegate iterator was exhausted and no keys matching diff merkle tree nodes were found");
    }

    @Override
    public void onBeforeIteration() {
        if (this.delegate instanceof NotifiableIterator) {
            ((NotifiableIterator)((Object)this.delegate)).onBeforeIteration();
        }
    }
}

