/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.PersistentConfigDescriptors;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.RamStoreRegistry;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.util.comparators.NativeValueComparator;
import com.hazelcast.internal.util.comparators.ValueComparator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterpriseLocalMapStatsProvider;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContextImpl;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.event.EnterpriseMapEventPublisherImpl;
import com.hazelcast.map.impl.event.MapEventPublisherImpl;
import com.hazelcast.map.impl.nearcache.EnterpriseMapNearCacheManager;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.map.impl.operation.EnterpriseMapPartitionClearOperation;
import com.hazelcast.map.impl.query.HDPartitionScanExecutor;
import com.hazelcast.map.impl.query.HDPartitionScanRunner;
import com.hazelcast.map.impl.query.QueryRunner;
import com.hazelcast.map.impl.query.ResultProcessorRegistry;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.EnterpriseRecordStore;
import com.hazelcast.map.impl.recordstore.EnterpriseTieredRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.wan.MapFilterProvider;
import com.hazelcast.query.impl.HDGlobalIndexProvider;
import com.hazelcast.query.impl.HDIndexProvider;
import com.hazelcast.query.impl.IndexProvider;
import com.hazelcast.query.impl.TSGlobalIndexProvider;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

class EnterpriseMapServiceContextImpl
extends MapServiceContextImpl
implements EnterpriseMapServiceContext,
RamStoreRegistry {
    private static final int MAP_PARTITION_CLEAR_OPERATION_AWAIT_SECONDS = 10;
    private final QueryRunner hdMapQueryRunner;
    private final IndexProvider hdIndexProvider;
    private final MapFilterProvider mapFilterProvider;
    private HotRestartIntegrationService hotRestartService;
    private final boolean globalIndexEnabled;
    private final IndexProvider tstoreIndexProvider;

    EnterpriseMapServiceContextImpl(NodeEngine nodeEngine) {
        super(nodeEngine);
        this.mapFilterProvider = new MapFilterProvider(nodeEngine);
        this.hdMapQueryRunner = this.createHDMapQueryRunner(new HDPartitionScanRunner(this), this.getQueryOptimizer(), this.getResultProcessorRegistry());
        this.globalIndexEnabled = this.getNodeEngine().getProperties().getBoolean(ClusterProperty.GLOBAL_HD_INDEX_ENABLED);
        this.hdIndexProvider = this.globalIndexEnabled() ? new HDGlobalIndexProvider() : new HDIndexProvider();
        Node node = ((NodeEngineImpl)nodeEngine).getNode();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)node.getNodeExtension();
        this.tstoreIndexProvider = new TSGlobalIndexProvider(node);
        if (nodeExtension.isHotRestartEnabled()) {
            this.hotRestartService = (HotRestartIntegrationService)nodeExtension.getInternalHotRestartService();
            this.hotRestartService.registerRamStoreRegistry("hz:impl:mapService", this);
        }
        ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(new MetricsProvider(this.getMapContainers()));
    }

    private QueryRunner createHDMapQueryRunner(HDPartitionScanRunner runner, QueryOptimizer queryOptimizer, ResultProcessorRegistry resultProcessorRegistry) {
        return new QueryRunner(this, queryOptimizer, new HDPartitionScanExecutor(runner), resultProcessorRegistry);
    }

    @Override
    protected PartitionContainer createPartitionContainer(MapService service, int partitionId) {
        return new EnterprisePartitionContainer(service, partitionId);
    }

    @Override
    protected LocalMapStatsProvider createLocalMapStatsProvider() {
        return new EnterpriseLocalMapStatsProvider(this);
    }

    @Override
    MapContainer createMapContainer(String mapName) {
        return new EnterpriseMapContainer(mapName, this.getNodeEngine().getConfig(), this);
    }

    @Override
    MapNearCacheManager createMapNearCacheManager() {
        return new EnterpriseMapNearCacheManager(this);
    }

    @Override
    MapEventPublisherImpl createMapEventPublisherSupport() {
        return new EnterpriseMapEventPublisherImpl(this);
    }

    @Override
    public ValueComparator getValueComparatorOf(InMemoryFormat inMemoryFormat) {
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            return NativeValueComparator.INSTANCE;
        }
        return super.getValueComparatorOf(inMemoryFormat);
    }

    @Override
    public HotRestartStore getOnHeapHotRestartStoreForPartition(int partitionId) {
        return this.hotRestartService.getOnHeapHotRestartStoreForPartition(partitionId);
    }

    @Override
    public HotRestartStore getOffHeapHotRestartStoreForPartition(int partitionId) {
        return this.hotRestartService.getOffHeapHotRestartStoreForPartition(partitionId);
    }

    @Override
    public RamStore ramStoreForPrefix(long prefix) {
        String name;
        int partitionId = PersistentConfigDescriptors.toPartitionId(prefix);
        EnterpriseRecordStore recordStore = (EnterpriseRecordStore)this.getExistingRecordStore(partitionId, name = this.hotRestartService.getCacheName(prefix));
        return recordStore == null ? null : recordStore.getRamStore();
    }

    @Override
    public RamStore restartingRamStoreForPrefix(long prefix) {
        int partitionId = PersistentConfigDescriptors.toPartitionId(prefix);
        String name = this.hotRestartService.getCacheName(prefix);
        PartitionContainer partitionContainer = this.getPartitionContainer(partitionId);
        EnterpriseRecordStore recordStore = (EnterpriseRecordStore)partitionContainer.getRecordStoreForHotRestart(name);
        return recordStore.getRamStore();
    }

    @Override
    public int prefixToThreadId(long prefix) {
        throw new UnsupportedOperationException("prefixToThreadId() should not have been called on this class");
    }

    @Override
    public MapFilterProvider getMapFilterProvider() {
        return this.mapFilterProvider;
    }

    @Override
    public QueryRunner getMapQueryRunner(String mapName) {
        if (this.getInMemoryFormat(mapName) == InMemoryFormat.NATIVE) {
            return this.hdMapQueryRunner;
        }
        return super.getMapQueryRunner(mapName);
    }

    private InMemoryFormat getInMemoryFormat(String mapName) {
        MapContainer container = this.getMapContainer(mapName);
        MapConfig mapConfig = container.getMapConfig();
        return mapConfig.getInMemoryFormat();
    }

    @Override
    public Data toData(Object object) {
        return ((EnterpriseSerializationService)this.getNodeEngine().getSerializationService()).toData(object, DataType.HEAP);
    }

    @Override
    protected void removeAllRecordStoresOfAllMaps(boolean onShutdown, boolean onRecordStoreDestroy) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        ArrayList<EnterpriseMapPartitionClearOperation> operations = new ArrayList<EnterpriseMapPartitionClearOperation>();
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            PartitionContainer partitionContainer = this.getPartitionContainer(i);
            ConcurrentMap<String, RecordStore> maps = partitionContainer.getMaps();
            if (maps.isEmpty()) continue;
            EnterpriseMapPartitionClearOperation operation = new EnterpriseMapPartitionClearOperation(onShutdown);
            operation.setPartitionId(i).setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler()).setNodeEngine(nodeEngine).setService(this.getService());
            if (operationService.isRunAllowed(operation)) {
                operationService.run(operation);
                continue;
            }
            operationService.execute(operation);
            operations.add(operation);
        }
        for (EnterpriseMapPartitionClearOperation operation : operations) {
            try {
                operation.awaitCompletion(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                nodeEngine.getLogger(this.getClass()).warning(e);
            }
        }
    }

    @Override
    public RecordStore createRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader) {
        NodeEngine nodeEngine = this.getNodeEngine();
        ILogger logger = nodeEngine.getLogger(DefaultRecordStore.class);
        if (mapContainer.getMapConfig().getTieredStoreConfig().isEnabled()) {
            return new EnterpriseTieredRecordStore(mapContainer, partitionId, keyLoader, logger);
        }
        long prefix = -1L;
        HotRestartConfig hotRestartConfig = this.getHotRestartConfig(mapContainer);
        if (hotRestartConfig.isEnabled()) {
            if (this.hotRestartService == null) {
                throw new HazelcastException("Hot Restart is enabled for map: " + mapContainer.getMapConfig().getName() + " but Hot Restart persistence is not enabled!");
            }
            String name = mapContainer.getName();
            this.hotRestartService.ensureHasConfiguration("hz:impl:mapService", name, null);
            prefix = this.hotRestartService.registerRamStore(this, "hz:impl:mapService", name, partitionId);
            if (!this.hotRestartService.isStartCompleted()) {
                ProxyServiceImpl proxyService = (ProxyServiceImpl)nodeEngine.getProxyService();
                UUID source = nodeEngine.getLocalMember().getUuid();
                proxyService.getOrCreateRegistry("hz:impl:mapService").getOrCreateProxyFuture(name, source, false, false);
            }
        }
        return new EnterpriseRecordStore(mapContainer, partitionId, keyLoader, logger, hotRestartConfig, prefix);
    }

    private HotRestartConfig getHotRestartConfig(MapContainer mapContainer) {
        HotRestartConfig hotRestartConfig = mapContainer.getMapConfig().getHotRestartConfig();
        return hotRestartConfig;
    }

    @Override
    public IndexProvider getIndexProvider(MapConfig mapConfig) {
        if (mapConfig.getInMemoryFormat() != InMemoryFormat.NATIVE) {
            return super.getIndexProvider(mapConfig);
        }
        if (mapConfig.getTieredStoreConfig().isEnabled()) {
            return this.tstoreIndexProvider;
        }
        return this.hdIndexProvider;
    }

    @Override
    public boolean globalIndexEnabled() {
        return this.globalIndexEnabled;
    }

    @Override
    public boolean shouldEnableMerkleTree(MapConfig mapConfig, boolean log) {
        boolean implicitlyEnabled;
        boolean bl = implicitlyEnabled = mapConfig.getHotRestartConfig().isEnabled() && mapConfig.getMerkleTreeConfig().getEnabled() == null;
        if (implicitlyEnabled && log) {
            EnterpriseMapContainer mapContainer = (EnterpriseMapContainer)this.getMapContainer(mapConfig.getName());
            mapContainer.logMerkleTreeImplicitlyEnabled(this.logger);
        }
        return Boolean.TRUE.equals(mapConfig.getMerkleTreeConfig().getEnabled()) || implicitlyEnabled;
    }

    private static final class MetricsProvider
    implements DynamicMetricsProvider {
        private final Map<String, MapContainer> mapContainers;

        private MetricsProvider(Map<String, MapContainer> mapContainers) {
            this.mapContainers = mapContainers;
        }

        @Override
        public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
            descriptor.withPrefix("map");
            for (MapContainer mapContainer : this.mapContainers.values()) {
                if (!(mapContainer instanceof EnterpriseMapContainer)) continue;
                context.collect(descriptor.copy().withDiscriminator("name", mapContainer.name), ((EnterpriseMapContainer)mapContainer).getHDStorageInfo());
            }
        }
    }
}

