/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.domain;

import java.io.Serializable;

public enum LicenseType implements Serializable
{
    MANAGEMENT_CENTER(1, "Management Center"),
    ENTERPRISE(0, "Enterprise"),
    ENTERPRISE_SECURITY_ONLY(2, "Enterprise only with security"),
    ENTERPRISE_HD(3, "Enterprise HD"),
    CUSTOM(4, "Custom");

    private final int code;
    private final String text;

    private LicenseType(int code, String text) {
        this.code = code;
        this.text = text;
    }

    public int getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public static LicenseType getDefault() {
        return ENTERPRISE;
    }

    public static LicenseType getLicenseType(int code) {
        for (LicenseType licenseType : LicenseType.values()) {
            if (licenseType.getCode() != code) continue;
            return licenseType;
        }
        return null;
    }
}

