/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.domain;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.LicenseChannel;
import com.hazelcast.license.domain.LicenseType;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.util.Base64;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class License
implements Serializable {
    public static final int UNLIMITED_MARKER = 9999;
    public static final int UNLIMITED_MARKER_HD_CACHE = 99999999;
    private int allowedNumberOfNodes;
    private LicenseType type;
    private LicenseVersion version;
    private long licenseId;
    private String pardotId;
    private String companyName;
    private String licenseName;
    private String email;
    private Boolean trial;
    private String key;
    private Date creationDate;
    private Date expiryDate;
    private int allowedNativeMemorySize;
    private int allowedTieredStoreSize;
    private LicenseChannel licenseChannel;
    private String creatorEmail;
    private int hazelcastVersion;
    private int customTypeId;
    private boolean oem;
    private int gracePeriod;
    private List<Feature> features;

    public int getAllowedNumberOfNodes() {
        return this.allowedNumberOfNodes;
    }

    public void setAllowedNumberOfNodes(int allowedNumberOfNodes) {
        this.allowedNumberOfNodes = allowedNumberOfNodes;
    }

    public LicenseType getType() {
        return this.type;
    }

    public void setType(LicenseType type) {
        this.type = type;
    }

    public LicenseVersion getVersion() {
        return this.version;
    }

    public void setVersion(LicenseVersion version) {
        this.version = version;
    }

    public long getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(long licenseId) {
        this.licenseId = licenseId;
    }

    public String getPardotId() {
        return this.pardotId;
    }

    public void setPardotId(String pardotId) {
        this.pardotId = pardotId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean isTrial() {
        return this.trial;
    }

    public void setTrial(Boolean trial) {
        this.trial = trial;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public int getAllowedNativeMemorySize() {
        return this.allowedNativeMemorySize;
    }

    public void setAllowedNativeMemorySize(int allowedNativeMemorySize) {
        this.allowedNativeMemorySize = allowedNativeMemorySize;
    }

    public int getAllowedTieredStoreSize() {
        return this.allowedTieredStoreSize;
    }

    public void setAllowedTieredStoreSize(int allowedTieredStoreSize) {
        this.allowedTieredStoreSize = allowedTieredStoreSize;
    }

    public LicenseChannel getLicenseChannel() {
        return this.licenseChannel;
    }

    public void setLicenseChannel(LicenseChannel licenseChannel) {
        this.licenseChannel = licenseChannel;
    }

    public String getCreatorEmail() {
        return this.creatorEmail;
    }

    public void setCreatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
    }

    public int getHazelcastVersion() {
        return this.hazelcastVersion;
    }

    public void setHazelcastVersion(int hazelcastVersion) {
        this.hazelcastVersion = hazelcastVersion;
    }

    public int getCustomTypeId() {
        return this.customTypeId;
    }

    public void setCustomTypeId(int customTypeId) {
        this.customTypeId = customTypeId;
    }

    public boolean isOem() {
        return this.oem;
    }

    public void setOem(boolean oem) {
        this.oem = oem;
    }

    public int getGracePeriod() {
        return this.gracePeriod;
    }

    public void setGracePeriod(int gracePeriod) {
        this.gracePeriod = gracePeriod;
    }

    public License() {
    }

    public License(int licenseId, String key, String companyName, Date creationDate, Date expiryDate, boolean isTrial, String email, String pardotId, int allowedNumberOfNodes, int allowedNativeMemorySize, LicenseType type, int hazelcastVersion, boolean oem, int gracePeriod) {
        this.licenseId = licenseId;
        this.key = key;
        this.allowedNumberOfNodes = allowedNumberOfNodes;
        this.type = type;
        this.companyName = companyName;
        this.email = email;
        this.pardotId = pardotId;
        this.trial = isTrial;
        this.creationDate = creationDate;
        this.expiryDate = expiryDate;
        this.allowedNativeMemorySize = allowedNativeMemorySize;
        this.hazelcastVersion = hazelcastVersion;
        this.oem = oem;
        this.gracePeriod = gracePeriod;
        this.features = new ArrayList<Feature>();
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public String computeKeyHash() {
        MessageDigest md;
        if (this.key == null) {
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        Charset charsetUtf8 = StandardCharsets.UTF_8;
        byte[] hash = md.digest(this.key.getBytes(charsetUtf8));
        return new String(Base64.encode(hash), charsetUtf8);
    }

    private String formatHazelcastVersion() {
        if (this.hazelcastVersion < 310) {
            int majorPart = this.hazelcastVersion / 10;
            int minorPart = this.hazelcastVersion % 10;
            return majorPart + "." + minorPart;
        }
        int majorPart = this.hazelcastVersion / 100;
        int minorPart1 = this.hazelcastVersion % 100;
        return majorPart + "." + minorPart1;
    }

    private String listFeatures() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        for (int i = 0; i < this.features.size(); ++i) {
            builder.append(this.features.get(i).getText());
            if (i >= this.features.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(" ]");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof License)) {
            return false;
        }
        License license = (License)o;
        if (this.allowedNumberOfNodes != license.allowedNumberOfNodes) {
            return false;
        }
        if (this.allowedNativeMemorySize != license.allowedNativeMemorySize) {
            return false;
        }
        if (this.allowedTieredStoreSize != license.allowedTieredStoreSize) {
            return false;
        }
        if (this.trial != null ? !this.trial.equals(license.trial) : license.trial != null) {
            return false;
        }
        if (this.licenseId != license.licenseId) {
            return false;
        }
        if (this.pardotId != null ? !this.pardotId.equals(license.pardotId) : license.pardotId != null) {
            return false;
        }
        if (this.companyName != null ? !this.companyName.equals(license.companyName) : license.companyName != null) {
            return false;
        }
        if (this.creationDate != null ? !this.creationDate.equals(license.creationDate) : license.creationDate != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(license.email) : license.email != null) {
            return false;
        }
        if (this.expiryDate != null ? !this.expiryDate.equals(license.expiryDate) : license.expiryDate != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(license.key) : license.key != null) {
            return false;
        }
        if (this.type != license.type) {
            return false;
        }
        if (this.hazelcastVersion != license.hazelcastVersion) {
            return false;
        }
        if (this.version != license.version) {
            return false;
        }
        if (this.oem != license.oem) {
            return false;
        }
        if (this.gracePeriod != license.gracePeriod) {
            return false;
        }
        if (this.licenseName != null ? !this.licenseName.equals(license.licenseName) : license.licenseName != null) {
            return false;
        }
        if (this.licenseChannel != null ? !this.licenseChannel.equals(license.licenseChannel) : license.licenseChannel != null) {
            return false;
        }
        if (this.creatorEmail != null ? !this.creatorEmail.equals(license.creatorEmail) : license.creatorEmail != null) {
            return false;
        }
        if (this.customTypeId != license.customTypeId) {
            return false;
        }
        return !(this.features != null ? !this.features.equals(license.features) : license.features != null);
    }

    public int hashCode() {
        int result = this.allowedNumberOfNodes;
        result = 31 * result + (int)this.licenseId;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.pardotId == null ? 0 : this.pardotId.hashCode());
        result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.trial != null && this.trial != false ? 1 : 0);
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (this.expiryDate != null ? this.expiryDate.hashCode() : 0);
        result = 31 * result + this.allowedNativeMemorySize;
        result = 31 * result + this.allowedTieredStoreSize;
        result = 31 * result + this.hazelcastVersion;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.licenseName == null ? 0 : this.licenseName.hashCode());
        result = 31 * result + this.customTypeId;
        result = 31 * result + (this.oem ? 1 : 0);
        result = 31 * result + this.gracePeriod;
        result = 31 * result + (this.licenseChannel == null ? 0 : this.licenseChannel.hashCode());
        result = 31 * result + (this.creatorEmail == null ? 0 : this.creatorEmail.hashCode());
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        return result;
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat("MMM/dd/yyyy HH:mm:ss");
        return "License{allowedNumberOfNodes=" + this.allowedNumberOfNodes + ", expiryDate=" + formatter.format(this.expiryDate) + ", featureList=" + this.listFeatures() + ", type=" + (this.type != null ? this.type.getText() : null) + ", companyName=" + this.companyName + ", ownerEmail=" + this.email + ", keyHash=" + this.computeKeyHash() + (this.hazelcastVersion == 99 ? ", No Version Restriction" : ", restrictedToVersion=" + this.formatHazelcastVersion()) + '}';
    }
}

