/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorConfigurator;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorType;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.LogBasedHybridLogIterator;
import com.hazelcast.internal.util.Preconditions;
import java.util.Iterator;
import java.util.Objects;

class HybridLogIteratorConfiguratorImpl<P, T>
implements HybridLogIteratorConfigurator<P, T> {
    private static final long UNSET = -1L;
    private final HybridLogImpl log;
    private HybridLogIteratorType type = HybridLogIteratorType.BOUNDED;
    private long startLogicalAddress;
    private long endLogicalAddress;
    private InMemorySlotAccessor<P, T> slotAccessor;

    HybridLogIteratorConfiguratorImpl(HybridLogImpl log) {
        this.log = log;
        this.startLogicalAddress = log.getFirstValidLogicalAddress() + 8L;
        this.endLogicalAddress = -1L;
    }

    public LogBasedConfiguratorImpl logBased() {
        return new LogBasedConfiguratorImpl();
    }

    public IndexBasedHybridLogConfiguratorImpl indexBased() {
        return new IndexBasedHybridLogConfiguratorImpl();
    }

    private Iterator<T> create() {
        switch (this.type) {
            case BOUNDED: {
                if (this.endLogicalAddress != -1L) {
                    Preconditions.checkTrue(this.startLogicalAddress <= this.endLogicalAddress, String.format("The starting logical address must be <= end logical address. Configured values: start=%s, end=%s", this.log.pager.prettyFormat(this.startLogicalAddress), this.log.pager.prettyFormat(this.endLogicalAddress)));
                } else {
                    this.endLogicalAddress = this.log.lastAllocatedAddress();
                }
                return new LogBasedHybridLogIterator<P, T>(this.log, this.startLogicalAddress, this.endLogicalAddress, Objects.requireNonNull(this.slotAccessor, "The SlotAccessor must be set"), this.type);
            }
            case LIVE: {
                return new LogBasedHybridLogIterator<P, T>(this.log, this.startLogicalAddress, Objects.requireNonNull(this.slotAccessor, "The SlotAccessor must be set"), this.type);
            }
        }
        throw new IllegalStateException("Unhandled hybrid log iterator type: " + (Object)((Object)this.type));
    }

    private class IndexBasedHybridLogConfiguratorImpl
    implements HybridLogIteratorConfigurator.IndexBasedConfigurator<P, T> {
        private IndexBasedHybridLogConfiguratorImpl() {
        }
    }

    private final class LogBasedLiveConfiguratorImpl
    extends AbstractHybridLogConfigurator<HybridLogIteratorConfigurator.LogBasedLiveConfigurator<P, T>>
    implements HybridLogIteratorConfigurator.LogBasedLiveConfigurator<P, T> {
        private LogBasedLiveConfiguratorImpl() {
            HybridLogIteratorConfiguratorImpl.this.endLogicalAddress = Long.MAX_VALUE;
        }

        @Override
        public Iterator<T> create() {
            return HybridLogIteratorConfiguratorImpl.this.create();
        }
    }

    private final class LogBasedBoundedConfiguratorImpl
    extends AbstractHybridLogConfigurator<HybridLogIteratorConfigurator.LogBasedBoundedConfigurator<P, T>>
    implements HybridLogIteratorConfigurator.LogBasedBoundedConfigurator<P, T> {
        private LogBasedBoundedConfiguratorImpl() {
        }

        @Override
        public HybridLogIteratorConfigurator.LogBasedBoundedConfigurator<P, T> endsAt(long endLogicalAddress) {
            HybridLogIteratorConfiguratorImpl.this.endLogicalAddress = Preconditions.checkNotNegative(endLogicalAddress, "Parameter endLogicalAddress must not be negative");
            return this;
        }

        @Override
        public Iterator<T> create() {
            return HybridLogIteratorConfiguratorImpl.this.create();
        }
    }

    private class LogBasedConfiguratorImpl
    extends AbstractHybridLogConfigurator<HybridLogIteratorConfigurator.LogBasedConfigurator<P, T>>
    implements HybridLogIteratorConfigurator.LogBasedConfigurator<P, T> {
        private LogBasedConfiguratorImpl() {
        }

        @Override
        public HybridLogIteratorConfigurator.LogBasedBoundedConfigurator<P, T> bounded() {
            HybridLogIteratorConfiguratorImpl.this.type = HybridLogIteratorType.BOUNDED;
            return new LogBasedBoundedConfiguratorImpl();
        }

        @Override
        public HybridLogIteratorConfigurator.LogBasedLiveConfigurator<P, T> live() {
            HybridLogIteratorConfiguratorImpl.this.type = HybridLogIteratorType.LIVE;
            return new LogBasedLiveConfiguratorImpl();
        }
    }

    private abstract class AbstractHybridLogConfigurator<C>
    implements HybridLogIteratorConfigurator.CommonLogBasedConfigurator<C, P, T> {
        private AbstractHybridLogConfigurator() {
        }

        @Override
        public C startsAt(long startLogicalAddress) {
            HybridLogIteratorConfiguratorImpl.this.startLogicalAddress = Preconditions.checkNotNegative(startLogicalAddress, "Parameter startLogicalAddress must not be negative");
            return (C)this;
        }

        @Override
        public C accessWith(InMemorySlotAccessor<P, T> slotAccessor) {
            HybridLogIteratorConfiguratorImpl.this.slotAccessor = Objects.requireNonNull(slotAccessor, "Parameter slotAccessor must not be null");
            return (C)this;
        }
    }
}

