/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog;

import com.hazelcast.internal.memory.MemoryAddressTranslator;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.device.ChunkAccessor;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorConfigurator;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import java.util.concurrent.CompletableFuture;

public interface HybridLog
extends MemoryAllocator,
MemoryAddressTranslator {
    public static final long SPEC_ADDRESS_WAITING_FOR_CLOSE = -1L;
    public static final long SPEC_ADDRESS_WAITING_FOR_FLUSH = -2L;

    @Override
    public boolean isInMemory(long var1);

    public boolean isMutable(long var1);

    public boolean isValidAddress(long var1);

    @Override
    public long allocate(long var1);

    public long tryAllocate(long var1);

    public <P, T> T readRecordForReadOnly(long var1, InMemorySlotAccessor<P, T> var3, AddressRemapper<T> var4, byte[] var5);

    public <P, T> T readRecordForUpdate(long var1, InMemorySlotAccessor<P, T> var3, AddressRemapper<T> var4, byte[] var5);

    public <P, T> T readRecordForReadOnly(long var1, InMemorySlotAccessor<P, T> var3, AddressRemapper<T> var4);

    public <P, T> T readRecordForUpdate(long var1, InMemorySlotAccessor<P, T> var3, AddressRemapper<T> var4);

    public <P, T> byte[] readRecordFromDevice(long var1, InMemorySlotAccessor<P, T> var3);

    public <P, T> Data readRecordValue(long var1, InMemorySlotAccessor<P, T> var3);

    public byte[] readChunk(long var1, byte[] var3, ChunkAccessor var4);

    public <P, T> CompletableFuture<T> readRecordAsync(long var1, InMemorySlotAccessor<P, T> var3, AddressRemapper<T> var4);

    public <P, T> CompletableFuture<T> readRecordAsyncForUpdate(long var1, InMemorySlotAccessor<P, T> var3, AddressRemapper<T> var4);

    public <P, T> HybridLogIteratorConfigurator<P, T> iterators();

    public <P, T> HybridLogIteratorConfigurator<P, T> iterators(Class<T> var1);

    default public boolean pinAddress(long logicalAddress) {
        throw new UnsupportedOperationException("Method pinAddress() is not supported by this HybridLog implementation");
    }

    default public boolean pinAddressForUpdate(long logicalAddress) {
        throw new UnsupportedOperationException("Method pinForUpdateAddress() is not supported by this HybridLog implementation");
    }

    default public void unpinAddress(long logicalAddress) {
        throw new UnsupportedOperationException("Method unpinAddress() is not supported by this HybridLog implementation");
    }

    default public boolean isAddressPinned(long logicalAddress) {
        throw new UnsupportedOperationException("Method isAddressPinned() is not supported by this HybridLog implementation");
    }
}

