/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import com.hazelcast.internal.tstore.device.ImmutableOperation;
import com.hazelcast.internal.tstore.device.RecordAccessor;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import java.io.IOException;
import java.io.RandomAccessFile;

final class ReadRecordOperation
extends ImmutableOperation {
    private final long logicalAddress;
    private final RecordAccessor recordAccessor;

    ReadRecordOperation(int storeId, Device device, long logicalAddress, RecordAccessor recordAccessor) {
        super(storeId, device);
        this.logicalAddress = logicalAddress;
        this.recordAccessor = recordAccessor;
    }

    LocalStorageDevice getDevice() {
        return (LocalStorageDevice)this.device;
    }

    @Override
    public byte[] run(byte[] context) {
        return ReadRecordOperation.run0(this.getDevice(), context, this.logicalAddress, this.recordAccessor);
    }

    static byte[] run0(LocalStorageDevice device, byte[] context, long logicalAddress, RecordAccessor recordAccessor) {
        long filePos = device.getLogFileOffsetFromLogicalAddress(logicalAddress);
        HybridLogFileHandlePool handlePool = device.getHandlePool();
        HybridLogFileHandleProvider hybridLogHandleProvider = device.getHandleProvider();
        int fileno = device.segmentNoOf(logicalAddress);
        HybridLogFileHandle handle = handlePool.getHandle(fileno, hybridLogHandleProvider);
        byte[] buf = context;
        RandomAccessFile raf = handle.getRaf();
        try {
            raf.seek(filePos);
            int bytes = raf.read(buf);
            if (bytes < recordAccessor.headerSize()) {
                throw new DeviceException(String.format("Cannot read from device `%s`.", device.deviceName()));
            }
            int recordLength = recordAccessor.length(buf);
            if (recordLength == buf.length) {
                byte[] byArray = buf;
                return byArray;
            }
            byte[] record = new byte[recordLength];
            int copy = Math.min(buf.length, recordLength);
            System.arraycopy(buf, 0, record, 0, copy);
            if (buf.length >= recordLength) {
                byte[] byArray = record;
                return byArray;
            }
            int rest = recordLength - copy;
            bytes = raf.read(record, copy, rest);
            if (bytes < rest) {
                throw new DeviceException(String.format("Cannot read from device `%s`.", device.deviceName()));
            }
            byte[] byArray = record;
            return byArray;
        }
        catch (IOException ioe) {
            throw new DeviceException(ioe);
        }
        finally {
            handlePool.releaseHandle(handle);
        }
    }

    @Override
    public int getReadLength() {
        return -1;
    }

    @Override
    public String toString() {
        return "ReadRecordOperation(" + this.storeId + ", " + this.device.deviceName() + this.logicalAddress + ")";
    }
}

