/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.compaction.CompactorExecutor;
import com.hazelcast.internal.tstore.compaction.CompactorFutureTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

class CompactorExecutorImpl
implements CompactorExecutor {
    private final BlockingQueue<CompactorFutureTask> compactorTaskQ;
    private final CompactorThread[] threads;
    private volatile boolean isTerminated;

    CompactorExecutorImpl(int nThreads) {
        this(nThreads, nThreads);
    }

    CompactorExecutorImpl(int nThreads, int capacity) {
        Invariants.greaterOrEqualThan(capacity, nThreads, "capacity cannot be smaller than number of threads");
        this.compactorTaskQ = new ArrayBlockingQueue<CompactorFutureTask>(capacity);
        this.threads = new CompactorThread[nThreads];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new CompactorThread("compactor-thread-" + i, this.compactorTaskQ);
            this.threads[i].start();
        }
    }

    @Override
    public void submit(CompactorFutureTask task) throws InterruptedException {
        if (this.isTerminated) {
            throw new IllegalStateException("the executor has been terminated");
        }
        this.compactorTaskQ.put(task);
    }

    @Override
    public void terminate() {
        if (this.isTerminated) {
            throw new IllegalStateException("the executor has already been terminated");
        }
        this.isTerminated = true;
        this.compactorTaskQ.forEach(compactor -> compactor.deregister());
        this.compactorTaskQ.clear();
        for (CompactorThread thread : this.threads) {
            thread.terminate();
        }
    }

    public BlockingQueue<CompactorFutureTask> getCompactorTaskQ() {
        return this.compactorTaskQ;
    }

    public Thread[] getThreads() {
        return this.threads;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    private class CompactorThread
    extends Thread {
        private final ILogger logger;
        private final BlockingQueue<CompactorFutureTask> compactorTaskQ;

        CompactorThread(String name, BlockingQueue<CompactorFutureTask> compactorTaskQ) {
            super(name);
            this.logger = Logger.getLogger(CompactorThread.class);
            this.compactorTaskQ = compactorTaskQ;
        }

        public void terminate() {
            this.interrupt();
        }

        @Override
        public void run() {
            while (!CompactorExecutorImpl.this.isTerminated) {
                this.run0();
            }
        }

        private void run0() {
            CompactorFutureTask task = null;
            try {
                task = this.compactorTaskQ.take();
                task.run();
            }
            catch (InterruptedException ie) {
                this.interrupt();
            }
            catch (Throwable th) {
                Throwable throwable = new Throwable("Exception/Error when running " + task + ":" + th.getMessage() + System.lineSeparator(), th);
                this.logger.warning(throwable);
            }
        }
    }
}

