/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.internal.tstore.compaction.CompactorConstructorFn;
import com.hazelcast.internal.tstore.compaction.CompactorExecutorImpl;
import com.hazelcast.internal.tstore.compaction.CompactorScheduler;
import com.hazelcast.internal.tstore.compaction.CompactorSchedulerImpl;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class CompactionManager {
    private static final int DEFAULT_COMPACTION_EXECUTOR_THREAD_COUNT = 1;
    private final Map<TStoreUserId, CompactorConstructorFns> userIdToCompactorConstructorFns;
    private final CompactorScheduler scheduler = new CompactorSchedulerImpl(new CompactorExecutorImpl(1));
    private final int partitionCnt;

    public CompactionManager(int partitionCnt) {
        this.partitionCnt = partitionCnt;
        this.userIdToCompactorConstructorFns = new ConcurrentHashMap<TStoreUserId, CompactorConstructorFns>(1);
    }

    public void addCompactorConstructorFn(TStoreUserId userId, int partitionId, CompactorConstructorFn constructorFn) {
        boolean success;
        while (!(success = this.userIdToCompactorConstructorFns.computeIfAbsent(userId, uid -> new CompactorConstructorFns(this.partitionCnt)).addConstructorFn(partitionId, constructorFn))) {
        }
    }

    public void removeCompactorConstructorFn(TStoreUserId userId, int partitionId, CompactorConstructorFn constructorFn) {
        CompactorConstructorFns compactorConstructorFns = this.userIdToCompactorConstructorFns.get(userId);
        boolean lastConstructorGotRemoved = compactorConstructorFns.removeConstructorFnAndTryDispose(partitionId, constructorFn);
        if (lastConstructorGotRemoved) {
            this.userIdToCompactorConstructorFns.remove(userId, compactorConstructorFns);
        }
    }

    public Future<Void> runCompactionIncremental(TStoreUserId userId, int partitionId, int segmentNo) {
        CompactorConstructorFn fn = this.userIdToCompactorConstructorFns.get(userId).incrementalCompactorConstructorFnOrNull(partitionId);
        assert (fn != null);
        Compactor<?> compactor = fn.newIncrementalCompactor(segmentNo);
        return this.scheduler.schedule(compactor, CompactorScheduler.Priority.MEDIUM);
    }

    public Future<Void> runCompactionFull(TStoreUserId userId, int partitionId) {
        CompactorConstructorFn fn = this.userIdToCompactorConstructorFns.get(userId).fullCompactorConstructorFnOrNull(partitionId);
        assert (fn != null);
        Compactor<?> compactor = fn.newFullCompactor();
        return this.scheduler.schedule(compactor, CompactorScheduler.Priority.MEDIUM);
    }

    public void terminate() {
        this.scheduler.terminate();
    }

    private static class CompactorConstructorFns {
        private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Lock rLock = this.rwLock.readLock();
        private final Lock wLock = this.rwLock.writeLock();
        private final List<CompactorConstructorFn>[] partitionConstructors;
        private int totalConstructorsCnt;

        CompactorConstructorFns(int partitionCnt) {
            this.partitionConstructors = new List[partitionCnt];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addConstructorFn(int partitionId, CompactorConstructorFn constructorFn) {
            this.wLock.lock();
            try {
                if (this.isDisposed()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.partitionConstructors[partitionId] == null) {
                    this.partitionConstructors[partitionId] = new LinkedList<CompactorConstructorFn>();
                }
                this.partitionConstructors[partitionId].add(constructorFn);
                ++this.totalConstructorsCnt;
                boolean bl = true;
                return bl;
            }
            finally {
                this.wLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeConstructorFnAndTryDispose(int partitionId, CompactorConstructorFn constructorFn) {
            this.wLock.lock();
            try {
                if (this.isDisposed()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.partitionConstructors[partitionId].remove(constructorFn)) {
                    --this.totalConstructorsCnt;
                }
                if (this.totalConstructorsCnt == 0) {
                    this.totalConstructorsCnt = -1;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.wLock.unlock();
            }
        }

        private boolean isDisposed() {
            return this.totalConstructorsCnt < 0;
        }

        CompactorConstructorFn incrementalCompactorConstructorFnOrNull(int partitionId) {
            return this.getConstructorFn(partitionId, true);
        }

        CompactorConstructorFn fullCompactorConstructorFnOrNull(int partitionId) {
            return this.getConstructorFn(partitionId, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompactorConstructorFn getConstructorFn(int partitionId, boolean incremental) {
            this.rLock.lock();
            try {
                if (this.isDisposed()) {
                    CompactorConstructorFn compactorConstructorFn = null;
                    return compactorConstructorFn;
                }
                for (CompactorConstructorFn fn : this.partitionConstructors[partitionId]) {
                    if (incremental && fn.isIncrementalSupported()) {
                        CompactorConstructorFn compactorConstructorFn = fn;
                        return compactorConstructorFn;
                    }
                    if (incremental || !fn.isFullSupported()) continue;
                    CompactorConstructorFn compactorConstructorFn = fn;
                    return compactorConstructorFn;
                }
                Iterator<CompactorConstructorFn> iterator = null;
                return iterator;
            }
            finally {
                this.rLock.unlock();
            }
        }
    }
}

