/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.VersionedObjectDataOutput;
import com.hazelcast.internal.util.collection.ArrayUtils;
import com.hazelcast.version.Version;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class FixedBufferObjectDataOutput
extends VersionedObjectDataOutput
implements BufferObjectDataOutput {
    private final InternalSerializationService service;
    private final boolean isBigEndian;
    private final byte[] buffer;
    private int pos;

    public FixedBufferObjectDataOutput(int size, InternalSerializationService service, ByteOrder byteOrder) {
        this.buffer = new byte[size];
        this.service = service;
        this.isBigEndian = byteOrder == ByteOrder.BIG_ENDIAN;
    }

    @Override
    public void write(int b) {
        if (this.isAvailable(1)) {
            this.buffer[this.pos] = (byte)b;
        }
        ++this.pos;
    }

    @Override
    public void write(int position, int b) {
        this.buffer[position] = (byte)b;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        ArrayUtils.boundsCheck(b.length, off, len);
        if (len == 0) {
            return;
        }
        if (this.isAvailable(len)) {
            System.arraycopy(b, off, this.buffer, this.pos, len);
        }
        this.pos += len;
    }

    @Override
    public final void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeBoolean(int position, boolean v) {
        this.write(position, v ? 1 : 0);
    }

    @Override
    public void writeBooleanBit(int position, int bitIndex, boolean v) throws IOException {
        byte b = this.buffer[position];
        b = v ? (byte)(b | 1 << bitIndex) : (byte)(b & ~(1 << bitIndex));
        this.buffer[position] = b;
    }

    @Override
    public final void writeByte(int v) {
        this.write(v);
    }

    @Override
    public final void writeZeroBytes(int count) {
        for (int k = 0; k < count; ++k) {
            this.write(0);
        }
    }

    @Override
    public final void writeByte(int position, int v) {
        this.write(position, v);
    }

    @Override
    public final void writeBytes(String s) {
        int len = s.length();
        if (this.isAvailable(len)) {
            for (int i = 0; i < len; ++i) {
                this.buffer[this.pos + i] = (byte)s.charAt(i);
            }
        }
        this.pos += len;
    }

    @Override
    public void writeChar(int v) {
        if (this.isAvailable(2)) {
            Bits.writeChar(this.buffer, this.pos, (char)v, this.isBigEndian);
        }
        this.pos += 2;
    }

    @Override
    public void writeChar(int position, int v) {
        Bits.writeChar(this.buffer, position, (char)v, this.isBigEndian);
    }

    @Override
    public void writeChars(String s) {
        int len = s.length();
        if (this.isAvailable(len * 2)) {
            for (int i = 0; i < len; ++i) {
                char v = s.charAt(i);
                this.writeChar(this.pos, v);
            }
        }
        this.pos += len * 2;
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeDouble(int position, double v) {
        this.writeLong(position, Double.doubleToLongBits(v));
    }

    @Override
    public void writeDouble(double v, ByteOrder byteOrder) {
        this.writeLong(Double.doubleToLongBits(v), byteOrder);
    }

    @Override
    public void writeDouble(int position, double v, ByteOrder byteOrder) {
        this.writeLong(position, Double.doubleToLongBits(v), byteOrder);
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeFloat(int position, float v) {
        this.writeInt(position, Float.floatToIntBits(v));
    }

    @Override
    public void writeFloat(float v, ByteOrder byteOrder) {
        this.writeInt(Float.floatToIntBits(v), byteOrder);
    }

    @Override
    public void writeFloat(int position, float v, ByteOrder byteOrder) {
        this.writeInt(position, Float.floatToIntBits(v), byteOrder);
    }

    @Override
    public void writeInt(int v) {
        if (this.isAvailable(4)) {
            Bits.writeInt(this.buffer, this.pos, v, this.isBigEndian);
        }
        this.pos += 4;
    }

    @Override
    public void writeInt(int position, int v) {
        Bits.writeInt(this.buffer, position, v, this.isBigEndian);
    }

    @Override
    public void writeInt(int v, ByteOrder byteOrder) {
        if (this.isAvailable(4)) {
            Bits.writeInt(this.buffer, this.pos, v, byteOrder == ByteOrder.BIG_ENDIAN);
        }
        this.pos += 4;
    }

    @Override
    public void writeInt(int position, int v, ByteOrder byteOrder) {
        Bits.writeInt(this.buffer, position, v, byteOrder == ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void writeLong(long v) {
        if (this.isAvailable(8)) {
            Bits.writeLong(this.buffer, this.pos, v, this.isBigEndian);
        }
        this.pos += 8;
    }

    @Override
    public void writeLong(int position, long v) {
        Bits.writeLong(this.buffer, position, v, this.isBigEndian);
    }

    @Override
    public void writeLong(long v, ByteOrder byteOrder) {
        if (this.isAvailable(8)) {
            Bits.writeLong(this.buffer, this.pos, v, byteOrder == ByteOrder.BIG_ENDIAN);
        }
        this.pos += 8;
    }

    @Override
    public void writeLong(int position, long v, ByteOrder byteOrder) {
        Bits.writeLong(this.buffer, position, v, byteOrder == ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void writeShort(int v) {
        if (this.isAvailable(2)) {
            Bits.writeShort(this.buffer, this.pos, (short)v, this.isBigEndian);
        }
        this.pos += 2;
    }

    @Override
    public void writeShort(int position, int v) {
        Bits.writeShort(this.buffer, position, (short)v, this.isBigEndian);
    }

    @Override
    public void writeShort(int v, ByteOrder byteOrder) {
        if (this.isAvailable(2)) {
            Bits.writeShort(this.buffer, this.pos, (short)v, byteOrder == ByteOrder.BIG_ENDIAN);
        }
        this.pos += 2;
    }

    @Override
    public void writeShort(int position, int v, ByteOrder byteOrder) {
        Bits.writeShort(this.buffer, position, (short)v, byteOrder == ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void writeUTF(String str) {
        this.writeString(str);
    }

    @Override
    public void writeString(@Nullable String str) {
        if (str == null) {
            this.writeInt(-1);
            return;
        }
        byte[] utf8Bytes = str.getBytes(StandardCharsets.UTF_8);
        this.writeInt(utf8Bytes.length);
        this.write(utf8Bytes);
    }

    @Override
    public void writeByteArray(byte[] bytes) {
        int len = bytes != null ? bytes.length : -1;
        this.writeInt(len);
        if (len > 0) {
            this.write(bytes);
        }
    }

    @Override
    public void writeBooleanArray(boolean[] booleans) {
        int len = booleans != null ? booleans.length : -1;
        this.writeInt(len);
        if (len > 0) {
            for (boolean b : booleans) {
                this.writeBoolean(b);
            }
        }
    }

    @Override
    public void writeCharArray(char[] chars) {
        int len = chars != null ? chars.length : -1;
        this.writeInt(len);
        if (len > 0) {
            for (char c : chars) {
                this.writeChar(c);
            }
        }
    }

    @Override
    public void writeIntArray(int[] ints) {
        int len = ints != null ? ints.length : -1;
        this.writeInt(len);
        if (len > 0) {
            for (int i : ints) {
                this.writeInt(i);
            }
        }
    }

    @Override
    public void writeLongArray(long[] longs) {
        int len = longs != null ? longs.length : -1;
        this.writeInt(len);
        if (len > 0) {
            for (long l : longs) {
                this.writeLong(l);
            }
        }
    }

    @Override
    public void writeDoubleArray(double[] doubles) {
        int len = doubles != null ? doubles.length : -1;
        this.writeInt(len);
        if (len > 0) {
            for (double d : doubles) {
                this.writeDouble(d);
            }
        }
    }

    @Override
    public void writeFloatArray(float[] floats) {
        int len = floats != null ? floats.length : -1;
        this.writeInt(len);
        if (len > 0) {
            for (float f : floats) {
                this.writeFloat(f);
            }
        }
    }

    @Override
    public void writeShortArray(short[] shorts) {
        int len = shorts != null ? shorts.length : -1;
        this.writeInt(len);
        if (len > 0) {
            for (short s : shorts) {
                this.writeShort(s);
            }
        }
    }

    @Override
    public void writeUTFArray(String[] strings) {
        this.writeStringArray(strings);
    }

    @Override
    public void writeStringArray(@Nullable String[] strings) {
        int len = strings != null ? strings.length : -1;
        this.writeInt(len);
        if (len > 0) {
            for (String s : strings) {
                this.writeString(s);
            }
        }
    }

    private boolean isAvailable(int len) {
        return this.buffer.length - this.pos >= len;
    }

    @Override
    public void writeObject(Object object) {
        this.service.writeObject(this, object);
    }

    @Override
    public void writeData(Data data) {
        int len = data == null ? -1 : data.totalSize();
        this.writeInt(len);
        if (len > 0) {
            if (this.isAvailable(len)) {
                data.copyTo(this.buffer, this.pos);
            }
            this.pos += len;
        }
    }

    @Override
    public final int position() {
        return this.pos;
    }

    @Override
    public void position(int newPos) {
        if (newPos > this.pos || newPos < 0) {
            throw new IllegalArgumentException();
        }
        this.pos = newPos;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(0);
    }

    @Override
    public byte[] toByteArray(int padding) {
        if (this.pos == 0) {
            return new byte[padding];
        }
        byte[] newBuffer = new byte[padding + this.pos];
        System.arraycopy(this.buffer, 0, newBuffer, padding, this.pos);
        return newBuffer;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getBuffer() {
        return this.buffer;
    }

    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public void clear() {
        this.pos = 0;
        this.version = Version.UNKNOWN;
        this.wanProtocolVersion = Version.UNKNOWN;
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.service;
    }

    public String toString() {
        return "FixedBufferDataOutput{capacity=" + this.buffer.length + ", isBigEndian=" + this.isBigEndian + ", pos=" + this.pos + '}';
    }
}

