/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.partition.impl.EnterprisePartitionDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Arrays;

public final class MerkleTreeComparisonResponse
implements IdentifiedDataSerializable {
    private boolean fullSyncRequired;
    private int[] diff;

    public MerkleTreeComparisonResponse() {
    }

    public MerkleTreeComparisonResponse(boolean fullSyncRequired) {
        this.fullSyncRequired = fullSyncRequired;
    }

    public MerkleTreeComparisonResponse(int[] diff) {
        this.fullSyncRequired = false;
        this.diff = diff;
    }

    public boolean isFullSyncRequired() {
        return this.fullSyncRequired;
    }

    public int[] getDiff() {
        return this.diff;
    }

    @Override
    public int getFactoryId() {
        return EnterprisePartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.fullSyncRequired);
        if (!this.fullSyncRequired) {
            out.writeIntArray(this.diff);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.fullSyncRequired = in.readBoolean();
        if (!this.fullSyncRequired) {
            this.diff = in.readIntArray();
        }
    }

    public String toString() {
        return "MerkleTreeComparisonResponse{fullSyncRequired=" + this.fullSyncRequired + ", diff=" + Arrays.toString(this.diff) + '}';
    }
}

