/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.config.EndpointConfig;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.nio.ascii.MemcacheTextDecoder;
import com.hazelcast.internal.nio.ascii.RestApiTextDecoder;
import com.hazelcast.internal.nio.ascii.TextDecoder;
import com.hazelcast.internal.nio.ascii.TextEncoder;
import com.hazelcast.internal.nio.ssl.AbstractMultiSocketTLSChannelInitializer;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.SingleProtocolEncoder;
import com.hazelcast.internal.server.tcp.TextHandshakeDecoder;
import java.util.concurrent.Executor;

public class TextTLSChannelInitializer
extends AbstractMultiSocketTLSChannelInitializer {
    private final boolean rest;

    public TextTLSChannelInitializer(EndpointConfig endpointConfig, Executor tlsExecutor, ServerContext ioService, boolean rest) {
        super(endpointConfig, tlsExecutor, ioService);
        this.rest = rest;
    }

    @Override
    protected void initPipeline(Channel channel) {
        ServerConnection connection = (ServerConnection)channel.attributeMap().get(ServerConnection.class);
        SingleProtocolEncoder encoder = new SingleProtocolEncoder(new TextEncoder(connection));
        TextDecoder decoder = this.rest ? new RestApiTextDecoder(connection, (TextEncoder)encoder.getFirstOutboundHandler(), true) : new MemcacheTextDecoder(connection, (TextEncoder)encoder.getFirstOutboundHandler(), true);
        channel.outboundPipeline().addLast(encoder);
        channel.inboundPipeline().addLast(new TextHandshakeDecoder(this.rest ? ProtocolType.REST : ProtocolType.MEMCACHE, decoder, encoder));
    }
}

