/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import java.security.cert.Certificate;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;

final class TLSUtil {
    private static final Certificate[] EMPTY_CERTS = new Certificate[0];

    private TLSUtil() {
    }

    static void publishRemoteCertificates(SSLEngine sslEngine, Map attributeMap) {
        if (sslEngine.getUseClientMode() || sslEngine.getNeedClientAuth() || sslEngine.getWantClientAuth()) {
            Certificate[] certs;
            try {
                certs = sslEngine.getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                certs = EMPTY_CERTS;
            }
            attributeMap.putIfAbsent(Certificate.class, certs);
        }
    }
}

