/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.nio.ssl.TLSDecoder;
import com.hazelcast.internal.nio.ssl.TLSExecutor;
import com.hazelcast.internal.nio.ssl.TLSUtil;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.logging.Logger;
import java.io.EOFException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

public class TLSHandshakeDecoder
extends InboundHandler<ByteBuffer, Void> {
    private final SSLEngine sslEngine;
    private final TLSExecutor tlsExecutor;
    private final ByteBuffer appBuffer;
    private final ConcurrentMap attributeMap;
    private volatile boolean isHandshakeFailed;

    public TLSHandshakeDecoder(SSLEngine sslEngine, TLSExecutor tlsExecutor, ConcurrentMap attributeMap) {
        this.sslEngine = sslEngine;
        this.tlsExecutor = tlsExecutor;
        this.appBuffer = IOUtil.newByteBuffer(sslEngine.getSession().getApplicationBufferSize(), false);
        this.attributeMap = attributeMap;
    }

    @Override
    public void handlerAdded() {
        this.initSrcBuffer(this.sslEngine.getSession().getPacketBufferSize());
    }

    @Override
    public void interceptError(Throwable t) throws Throwable {
        if (t instanceof EOFException) {
            throw TLSHandshakeDecoder.newSSLException(t);
        }
    }

    static SSLException newSSLException(Throwable t) {
        return new SSLException("Remote socket closed during SSL/TLS handshake.  This is probably caused by a SSL/TLS authentication problem resulting in the remote side closing the socket.", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HandlerStatus onRead() throws Exception {
        JVMUtil.upcast((Buffer)this.src).flip();
        try {
            block17: while (true) {
                handshakeStatus = this.sslEngine.getHandshakeStatus();
                switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[handshakeStatus.ordinal()]) {
                    case 1: {
                        continue block17;
                    }
                    case 2: {
                        this.tlsExecutor.executeHandshakeTasks(this.sslEngine, this.channel);
                        var2_3 = HandlerStatus.BLOCKED;
                        return var2_3;
                    }
                    case 3: {
                        this.channel.outboundPipeline().wakeup();
                        var2_3 = HandlerStatus.BLOCKED;
                        return var2_3;
                    }
                    case 4: {
                        unwrapResult = this.sslEngine.unwrap((ByteBuffer)this.src, this.appBuffer);
                        unwrapStatus = unwrapResult.getStatus();
                        if (unwrapStatus == SSLEngineResult.Status.OK) continue block17;
                        if (unwrapStatus == SSLEngineResult.Status.CLOSED) {
                            var4_5 = HandlerStatus.CLEAN;
                            return var4_5;
                        }
                        if (unwrapStatus != SSLEngineResult.Status.BUFFER_UNDERFLOW) throw new IllegalStateException("Unexpected " + unwrapResult);
                        if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) ** break;
                        continue block17;
                        var4_6 = HandlerStatus.CLEAN;
                        return var4_6;
                    }
                    case 5: {
                        if (this.isHandshakeFailed) {
                            throw new SSLHandshakeException("TLS handshake failed.");
                        }
                        TLSUtil.publishRemoteCertificates(this.sslEngine, this.attributeMap);
                        tlsDecoder = new TLSDecoder(this.sslEngine);
                        this.channel.inboundPipeline().replace(this, new InboundHandler[]{tlsDecoder});
                        if (this.appBuffer.position() != 0) {
                            JVMUtil.upcast(this.appBuffer).flip();
                            tlsDecoder.appBuffer().put(this.appBuffer);
                        }
                        if (((ByteBuffer)this.src).hasRemaining()) {
                            ((ByteBuffer)tlsDecoder.src()).put((ByteBuffer)this.src);
                        }
                        this.channel.outboundPipeline().wakeup();
                        var5_8 = HandlerStatus.DIRTY;
                        return var5_8;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (SSLHandshakeException e) {
            if (this.isHandshakeFailed) {
                throw e;
            }
            this.isHandshakeFailed = true;
            Logger.getLogger(this.getClass()).fine("TLS handshake failed. The SSLEngine.closeInbound() will be called.", e);
            this.sslEngine.closeInbound();
            this.channel.outboundPipeline().wakeup();
            var2_3 = HandlerStatus.DIRTY;
            return var2_3;
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)this.src);
        }
    }
}

