/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.chunk;

import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.GrowingChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileOut;

public abstract class WriteThroughChunk
extends GrowingChunk {
    public final ChunkFileOut out;
    final GcHelper gcHelper;
    private final String suffix;

    WriteThroughChunk(long seq, String suffix, RecordMap records, ChunkFileOut out, GcHelper gcHelper) {
        super(seq, records);
        this.suffix = suffix;
        this.gcHelper = gcHelper;
        this.out = out;
    }

    public void flagForFsyncOnClose(boolean fsyncOnClose) {
        this.out.flagForFsyncOnClose(fsyncOnClose);
    }

    public void close() {
        this.out.close();
        this.gcHelper.changeSuffix(this.base(), this.seq, ".chunk" + this.suffix, ".chunk");
    }

    public void fsync() {
        this.out.fsync();
    }

    final boolean hasRoom() {
        assert (!this.full()) : String.format("Attempted to write to a full %s file #%x", this.base(), this.seq);
        return true;
    }

    public abstract StableChunk toStableChunk();
}

